/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.handler;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import top.aoyudi.deepseek.annotation.ToolFunction;
import top.aoyudi.deepseek.annotation.ToolParam;
import top.aoyudi.deepseek.entity.request.tool.DSReqFunction;
import top.aoyudi.deepseek.entity.request.tool.DSReqToolParameters;
import top.aoyudi.deepseek.handler.ToolRegister;

@Component
public class ToolFunctionPostProcessor
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        for (Method method : bean.getClass().getDeclaredMethods()) {
            ToolFunction annotation = method.getAnnotation(ToolFunction.class);
            if (annotation == null) continue;
            DSReqToolParameters parameters = this.buildParameters(method);
            DSReqFunction function = new DSReqFunction();
            function.setName(method.getName());
            function.setDescription(annotation.description());
            function.setParameters(parameters);
            ToolRegister.registerTool(bean, method, function);
        }
        return bean;
    }

    private DSReqToolParameters buildParameters(Method method) {
        DSReqToolParameters parameters = new DSReqToolParameters();
        ArrayList<String> requiredParams = new ArrayList<String>();
        for (Parameter param : method.getParameters()) {
            ToolParam paramAnn = param.getAnnotation(ToolParam.class);
            if (paramAnn == null) continue;
            DSReqToolParameters.Property prop = new DSReqToolParameters.Property(paramAnn.type(), paramAnn.description());
            parameters.getProperties().put(paramAnn.name(), prop);
            if (!paramAnn.required()) continue;
            requiredParams.add(paramAnn.name());
        }
        parameters.setRequired(requiredParams);
        return parameters;
    }
}

