/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import top.aoyudi.deepseek.annotation.ToolParam;
import top.aoyudi.deepseek.handler.ToolRegister;

public class ToolExecutor {
    private final Object bean;
    private final Method method;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static Object executeTool(String name, String argumentsJson) throws Exception {
        ToolExecutor executor = ToolRegister.tools.get(name);
        if (executor == null) {
            throw new IllegalStateException("\u5de5\u5177\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u4fdd\u8c03\u7528\u5de5\u5177\u540d\u4e0e@ToolFunction\u7684name\u4fdd\u6301\u4e00\u81f4");
        }
        Method method = executor.getMethod();
        method.setAccessible(true);
        if (method.getParameterCount() == 0) {
            return method.invoke(executor.getBean(), new Object[0]);
        }
        Object[] args = ToolExecutor.parseArguments(method, argumentsJson);
        return method.invoke(executor.getBean(), args);
    }

    private static Object[] parseArguments(Method method, String json) throws Exception {
        JsonNode rootNode = objectMapper.readTree(json);
        Parameter[] parameters = method.getParameters();
        Object[] args = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String fieldName;
            Parameter param = parameters[i];
            ToolParam annotation = param.getAnnotation(ToolParam.class);
            String string = fieldName = annotation != null && !annotation.name().isEmpty() ? annotation.name() : param.getName();
            if (!rootNode.has(fieldName)) {
                if (annotation != null && annotation.required()) {
                    throw new IllegalArgumentException("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570: " + fieldName);
                }
                args[i] = null;
                continue;
            }
            args[i] = objectMapper.convertValue((Object)rootNode.get(fieldName), param.getType());
        }
        return args;
    }

    public Object getBean() {
        return this.bean;
    }

    public Method getMethod() {
        return this.method;
    }

    public ToolExecutor(Object bean, Method method) {
        this.bean = bean;
        this.method = method;
    }
}

