/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.deepseek.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import top.aoyudi.deepseek.entity.enums.ErrorCodeEnum;
import top.aoyudi.deepseek.entity.response.balance.DSBalance;
import top.aoyudi.deepseek.service.DeepSeekService;
import top.aoyudi.starter.DeepSeekConfig;
import top.aoyudi.starter.DeepSeekProperties;

@Component
public class DeepSeekBalanceService {
    private static final Logger logger = LoggerFactory.getLogger(DeepSeekService.class);
    @Autowired
    private DeepSeekConfig deepSeekConfig;
    private final DeepSeekProperties deepSeekProperties;
    private final RestTemplate restTemplate;

    public DeepSeekBalanceService(DeepSeekProperties deepSeekProperties) {
        this.deepSeekProperties = deepSeekProperties;
        this.restTemplate = new RestTemplate();
    }

    public DSBalance getBalance() {
        HttpHeaders headers = this.deepSeekConfig.createHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        logger.info("Sending request to DeepSeek API...");
        ResponseEntity exchange = this.restTemplate.exchange(this.deepSeekProperties.getBalanceUrl(), HttpMethod.GET, entity, DSBalance.class, new Object[0]);
        return this.handleResponse((ResponseEntity<DSBalance>)exchange);
    }

    private DSBalance handleResponse(ResponseEntity<DSBalance> response) {
        if (response.getStatusCodeValue() == 200) {
            return (DSBalance)response.getBody();
        }
        int statusCode = response.getStatusCode().value();
        ErrorCodeEnum errorCode = ErrorCodeEnum.fromCode(statusCode);
        String errorMessage = errorCode != null ? errorCode.getDescription() + ": " + errorCode.getReason() : "\u672a\u77e5\u9519\u8bef\uff1a\u8bf7\u8054\u7cfb\u652f\u6301";
        logger.error("FinallyRequestBody failed with error: {}", (Object)errorMessage);
        throw new RuntimeException(errorMessage);
    }
}

