/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.rag.impl;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.aoyudi.rag.EmbeddingGenerator;

public class SimpleEmbeddingGenerator
implements EmbeddingGenerator {
    private static final Logger log = LogManager.getLogger(SimpleEmbeddingGenerator.class);
    private static final int EMBEDDING_DIMENSION = 128;

    @Override
    public float[] generate(String text) {
        log.info("Generating simple embedding for text (length: {})", (Object)text.length());
        float[] embedding = new float[128];
        int textHash = text.hashCode();
        for (int i = 0; i < 128; ++i) {
            long seed = (long)textHash * (long)(i + 1);
            embedding[i] = (float)((double)(seed % 2000L) / 1000.0 - 1.0);
        }
        return embedding;
    }
}

