/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.rag.util;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.Assert;
import top.aoyudi.deepseek.entity.request.message.DSUserReqMessage;
import top.aoyudi.rag.VectorStore;
import top.aoyudi.rag.properties.Document;

public class RagUtils {
    private static final Logger log = LogManager.getLogger(RagUtils.class);
    private final VectorStore vectorStore;

    public RagUtils(VectorStore vectorStore) {
        Assert.notNull((Object)vectorStore, (String)"VectorStore must not be null");
        this.vectorStore = vectorStore;
    }

    public DSUserReqMessage buildRagPrompt(String question, String repositoryKey) {
        log.info("Answering question with RAG from repository {}: {}", (Object)repositoryKey, (Object)question);
        List<Document> relevantDocs = this.vectorStore.similaritySearch(repositoryKey, question);
        StringBuilder prompt = new StringBuilder();
        prompt.append("Use the following context to answer the question. If you can't find the answer in the context, say you don't know.\n\n");
        prompt.append("Context:\n");
        for (int i = 0; i < relevantDocs.size(); ++i) {
            Document doc = relevantDocs.get(i);
            prompt.append("[").append(i + 1).append("] ").append(doc.getContent()).append("\n");
        }
        prompt.append("\nQuestion: ").append(question);
        prompt.append("\nAnswer: ");
        return ((DSUserReqMessage.DSUserReqMessageBuilder)DSUserReqMessage.builder().content(prompt.toString())).build();
    }
}

