/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.rag.config;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import top.aoyudi.rag.DocumentLoader;
import top.aoyudi.rag.EmbeddingGenerator;
import top.aoyudi.rag.TextSplitter;
import top.aoyudi.rag.VectorSimilarityCalc;
import top.aoyudi.rag.VectorStore;
import top.aoyudi.rag.impl.DocumentEmbeddingGenerator;
import top.aoyudi.rag.impl.FileSystemDocumentLoader;
import top.aoyudi.rag.impl.InMemoryVectorStore;
import top.aoyudi.rag.impl.RecursiveCharacterTextSplitter;
import top.aoyudi.rag.impl.VectorSimilarityCalcImpl;
import top.aoyudi.rag.properties.RagProperties;
import top.aoyudi.rag.util.RagUtils;

@Configuration
@ConditionalOnClass(value={RagProperties.class})
@EnableConfigurationProperties(value={RagProperties.class})
public class RagAutoConfiguration {
    private static final Logger log = LogManager.getLogger(RagAutoConfiguration.class);
    @Autowired
    private RagProperties ragProperties;

    @Bean
    @ConditionalOnMissingBean
    public TextSplitter textSplitter() {
        log.info("Configuring RecursiveCharacterTextSplitter with chunk size: {} and overlap: {}", (Object)this.ragProperties.getChunkSize(), (Object)this.ragProperties.getChunkOverlap());
        return new RecursiveCharacterTextSplitter(this.ragProperties.getChunkSize(), this.ragProperties.getChunkOverlap(), RecursiveCharacterTextSplitter.DEFAULT_SEPARATORS);
    }

    @Bean
    @ConditionalOnMissingBean
    public VectorSimilarityCalc vectorSimilarityCalc() {
        return new VectorSimilarityCalcImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public EmbeddingGenerator embeddingGenerator() {
        return new DocumentEmbeddingGenerator();
    }

    @Bean
    @ConditionalOnMissingBean
    public DocumentLoader fileSystemDocumentLoader() {
        return new FileSystemDocumentLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public VectorStore vectorStore(EmbeddingGenerator embeddingGenerator, TextSplitter textSplitter, VectorSimilarityCalc vectorSimilarityCalc) {
        return new InMemoryVectorStore(embeddingGenerator, textSplitter, vectorSimilarityCalc);
    }

    @Bean
    @ConditionalOnMissingBean
    public RagUtils ragUtils(VectorStore vectorStore) {
        return new RagUtils(vectorStore);
    }
}

