/*
 * Decompiled with CFR 0.152.
 */
package top.aoyudi.rag.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.aoyudi.rag.EmbeddingGenerator;
import top.aoyudi.rag.TextSplitter;
import top.aoyudi.rag.VectorSimilarityCalc;
import top.aoyudi.rag.VectorStore;
import top.aoyudi.rag.properties.Document;

public class InMemoryVectorStore
implements VectorStore {
    private static final Logger log = LogManager.getLogger(InMemoryVectorStore.class);
    private final Map<String, List<Document>> repositoryDocuments = new HashMap<String, List<Document>>();
    private final EmbeddingGenerator embeddingGenerator;
    private final VectorSimilarityCalc vectorSimilarityCalc;
    private final TextSplitter textSplitter;

    public InMemoryVectorStore(EmbeddingGenerator embeddingGenerator, TextSplitter textSplitter, VectorSimilarityCalc vectorSimilarityCalc) {
        this.embeddingGenerator = embeddingGenerator;
        this.textSplitter = textSplitter;
        this.vectorSimilarityCalc = vectorSimilarityCalc;
    }

    @Override
    public void createRepository(String repositoryKey) {
        this.repositoryDocuments.putIfAbsent(repositoryKey, new ArrayList());
        log.info("Created or verified repository: {}", (Object)repositoryKey);
    }

    @Override
    public void deleteRepository(String repositoryKey) {
        this.repositoryDocuments.remove(repositoryKey);
        log.info("Deleted repository: {}", (Object)repositoryKey);
    }

    @Override
    public List<String> listRepositories() {
        return new ArrayList<String>(this.repositoryDocuments.keySet());
    }

    @Override
    public void addDocument(String repositoryKey, Document document) {
        this.createRepository(repositoryKey);
        if (document.getVector() == null) {
            document.setVector(this.embeddingGenerator.generate(document.getContent()));
        }
        this.repositoryDocuments.get(repositoryKey).add(document);
        log.info("Added document to repository {}. Total documents: {}", (Object)repositoryKey, (Object)this.repositoryDocuments.get(repositoryKey).size());
    }

    @Override
    public void addDocuments(String repositoryKey, List<Document> documents) {
        log.info("Processing {} documents into repository {}...", (Object)documents.size(), (Object)repositoryKey);
        List<Document> chunks = documents.stream().flatMap(doc -> this.textSplitter.splitDocument((Document)doc).stream()).collect(Collectors.toList());
        log.info("Split {} documents into {} chunks", (Object)documents.size(), (Object)chunks.size());
        chunks.forEach(chunk -> this.addDocument(repositoryKey, (Document)chunk));
        log.info("Successfully added documents to repository {}", (Object)repositoryKey);
    }

    @Override
    public List<Document> similaritySearch(String repositoryKey, float[] queryVector) {
        List documents = this.repositoryDocuments.getOrDefault(repositoryKey, new ArrayList());
        return documents.stream().map(doc -> new DocumentScore((Document)doc, this.vectorSimilarityCalc.calcSimilarity(queryVector, doc.getVector()))).sorted((a, b) -> Float.compare(b.getScore(), a.getScore())).map(DocumentScore::getDocument).collect(Collectors.toList());
    }

    @Override
    public List<Document> similaritySearch(String repositoryKey, String queryText) {
        float[] queryVector = this.embeddingGenerator.generate(queryText);
        return this.similaritySearch(repositoryKey, queryVector);
    }

    @Override
    public void clear(String repositoryKey) {
        if (this.repositoryDocuments.containsKey(repositoryKey)) {
            this.repositoryDocuments.get(repositoryKey).clear();
            log.info("Cleared repository: {}", (Object)repositoryKey);
        } else {
            log.warn("Attempted to clear non-existent repository: {}", (Object)repositoryKey);
        }
    }

    private static class DocumentScore {
        private final Document document;
        private final float score;

        public DocumentScore(Document document, float score) {
            this.document = document;
            this.score = score;
        }

        public Document getDocument() {
            return this.document;
        }

        public float getScore() {
            return this.score;
        }
    }
}

