package top.bluesword.util.algorithm;

import org.apache.commons.codec.digest.DigestUtils;

import java.lang.management.ManagementFactory;

/**
 * 进程实例编码
 * @author 李林峰
 * @version 0.1
 */
public class InstanceCode {

    private static final String JAVA_VIRTUAL_MACHINE = ManagementFactory.getRuntimeMXBean().getName();

    private InstanceCode(){}

    private static final char[] DIGITS = {
            'a' , 'b' , 'c' , 'd' , 'e' , 'f' ,
            'g' , 'h' , 'i' , 'j' , 'k' , 'l' ,
            'm' , 'n' , 'o' , 'p' , 'q' , 'r' ,
            's' , 't' , 'u' , 'v' , 'w' , 'x' ,
            'y' , 'z' , 'A' , 'B' , 'C' , 'D' ,
            'E' , 'F' , 'G' , 'H' , 'I' , 'J' ,
            'K' , 'L' , 'M' , 'N' , 'O' , 'P' ,
            'Q' , 'R' , 'S' , 'T' , 'U' , 'V' ,
            'W' , 'X' , 'Y' , 'Z'
    };

    public static String getInstanceCode(){
        byte[] bytes = DigestUtils.sha1(JAVA_VIRTUAL_MACHINE);
        int b = (bytes[bytes.length - 2] & 0x7f)<<8 | (bytes[bytes.length - 1] & 0xff);
        int length = DIGITS.length;
        return new String(new char[]{DIGITS[b%length], DIGITS[(b/length)%length]});
    }
}