/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.algorithm.hash.bcrypt;

import java.util.Arrays;
import java.util.Random;
import org.mindrot.jbcrypt.BCrypt;

public class SwordBCrypt
extends BCrypt {
    private static final char[] SWORD_CODE = new char[]{'.', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private SwordBCrypt() {
    }

    public static String hash(String password) {
        String hashCode = BCrypt.hashpw((String)password, (String)BCrypt.gensalt((int)12)).replaceFirst("\\$2a\\$12\\$", "lfsword");
        int i = new Random().nextInt(SWORD_CODE.length);
        return hashCode + SWORD_CODE[i];
    }

    public static boolean check(String plaintext, String hashed) {
        char[] hashCharArray = hashed.toCharArray();
        char[] lfsword = "lfsword".toCharArray();
        char[] replace = "$2a$12$".toCharArray();
        for (int i = 0; i < replace.length; ++i) {
            if (hashCharArray[i] != lfsword[i]) {
                return false;
            }
            hashCharArray[i] = replace[i];
        }
        char[] really = Arrays.copyOfRange(hashCharArray, 0, hashCharArray.length - 1);
        return BCrypt.checkpw((String)plaintext, (String)new String(really));
    }
}

