/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.network;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import top.bluesword.util.exception.SwordRuntimeException;

public class HttpClientUtil {
    private HttpClientUtil() {
    }

    public static String sendPostJson(String url, String json) {
        return HttpClientUtil.sendPost(url, (HttpEntity)new StringEntity(json, "UTF-8"), new Header[]{new BasicHeader("Content-Encoding", "UTF-8"), new BasicHeader("content-type", "application/json")});
    }

    public static String sendPostParam(String url, Map<String, String> paramMap, Map<String, String> headersMap) {
        try {
            return HttpClientUtil.sendPost(url, (HttpEntity)new UrlEncodedFormEntity(HttpClientUtil.toPairList(paramMap), "UTF-8"), HttpClientUtil.toHeaders(headersMap));
        }
        catch (IOException e) {
            throw new SwordRuntimeException("\u53d1\u9001\u666e\u901a\u683c\u5f0f\u53c2\u6570\u7684post\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static String sendPost(String url, HttpEntity entity, Header[] headers) {
        try {
            return Request.Post((String)url).body(entity).setHeaders(headers).execute().returnContent().asString();
        }
        catch (IOException e) {
            throw new SwordRuntimeException("post\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static List<NameValuePair> toPairList(Map<String, String> paramMap) {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (paramMap != null) {
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                params.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        return params;
    }

    private static Header[] toHeaders(Map<String, String> headersMap) {
        Header[] headers = new Header[headersMap.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : headersMap.entrySet()) {
            headers[i++] = new BasicHeader(entry.getKey(), entry.getValue());
        }
        return headers;
    }

    public static String sendGet(String url, Map<String, String> paramMap, Map<String, String> headersMap) {
        try {
            String param = "";
            if (paramMap != null && paramMap.size() > 0) {
                param = URLEncodedUtils.format(HttpClientUtil.toPairList(paramMap), (String)"UTF-8");
            }
            Request request = Request.Get((String)(url + "?" + param)).connectTimeout(5000).socketTimeout(5000);
            if (headersMap != null) {
                for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                    request.addHeader(entry.getKey(), entry.getValue());
                }
            }
            return request.execute().returnContent().asString(Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new SwordRuntimeException("\u53d1\u9001get\u8bf7\u6c42\u5931\u8d25");
        }
    }

    public static String sendGet(String url) {
        return HttpClientUtil.sendGet(url, null, null);
    }

    public static String sendGet(String url, Map<String, String> paramMap) {
        return HttpClientUtil.sendGet(url, paramMap, null);
    }
}

