/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class LocalIpAddressUtil {
    private LocalIpAddressUtil() {
    }

    public static Set<InetAddress> resolveLocalAddresses() throws SocketException {
        HashSet<InetAddress> addresses = new HashSet<InetAddress>();
        Enumeration<NetworkInterface> ns = NetworkInterface.getNetworkInterfaces();
        while (ns.hasMoreElements()) {
            NetworkInterface n = ns.nextElement();
            Enumeration<InetAddress> is = n.getInetAddresses();
            while (is.hasMoreElements()) {
                InetAddress i = is.nextElement();
                if (i.isLoopbackAddress() || i.isLinkLocalAddress() || i.isMulticastAddress() || LocalIpAddressUtil.isSpecialIp(i.getHostAddress())) continue;
                addresses.add(i);
            }
        }
        return addresses;
    }

    public static Set<String> resolveLocalIps() throws SocketException {
        HashSet<String> ret = new HashSet<String>();
        for (InetAddress addr : LocalIpAddressUtil.resolveLocalAddresses()) {
            ret.add(addr.getHostAddress());
        }
        return ret;
    }

    private static boolean isSpecialIp(String ip) {
        return ip.contains(":") || ip.startsWith("169.254.") || ip.startsWith("127.");
    }
}

