package top.bluesword.util.algorithm.sort;

/**
 * 快速排序算法
 *
 * @author 李林峰
 */
public class QuickSort {

    private QuickSort() {}

    /**
     * int数组快速排序
     * @param array 等待排序数组
     */
    public static void quickSortInt(int[] array) {
        subQuickSort(array, 0, array.length - 1);
    }

    private static void subQuickSort(int[] array, int start, int end) {
        if (start >= end) return;
        int is = start;
        int ie = end;
        while (start < end) {
            while (start < end && array[start] <= array[end]) start++;
            exchangeElements(array, start, end);
            while (start < end && array[start] <= array[end]) end--;
            exchangeElements(array, start, end);
        }
        subQuickSort(array, is, end - 1);
        subQuickSort(array, start + 1, ie);
    }

    private static void exchangeElements(int[] array, int index1, int index2) {
        if (index1 < index2) {
            int temp = array[index1];
            array[index1] = array[index2];
            array[index2] = temp;
        }
    }
}
