package top.bluesword.util.base.math;

/**
 * 数字工具,进行36以下的任意进制转换
 *
 * @author 李林峰
 */
public interface NumericalUtil {

    /***
     *  36以內任何进制转换,
     * @param s 数字字符串
     * @param srcBase s的进制
     * @param destBase 要转换为的进制
     * @return 转换后的数字字符串
     */
    public static String baseConvert(String s, int srcBase, int destBase) {
        return Long.toString(Long.parseLong(s, srcBase), destBase);
    }

}