/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.algorithm.totp;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.jetbrains.annotations.NotNull;
import top.bluesword.util.exception.SwordRuntimeException;

public class SwordTimeAuthenticator {
    private static final int[] DIGITS_POWER = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    private SwordTimeAuthenticator() {
    }

    private static byte[] hmacSha(String crypto, byte[] keyBytes, byte[] text) throws NoSuchAlgorithmException {
        Mac mac = Mac.getInstance(crypto);
        try {
            mac.init(new SecretKeySpec(keyBytes, "RAW"));
        }
        catch (InvalidKeyException e) {
            throw new SwordRuntimeException("\u5bc6\u94a5\u751f\u6210\u5f02\u5e38");
        }
        return mac.doFinal(text);
    }

    private static byte[] hexStr2Bytes(String hexStr) {
        byte[] bArray = new BigInteger("10" + hexStr, 16).toByteArray();
        byte[] ret = new byte[bArray.length - 1];
        System.arraycopy(bArray, 1, ret, 0, ret.length);
        return ret;
    }

    private static String generateOTP(String key, @NotNull String message, int codeDigits) {
        byte[] hash;
        String crypto = "HmacSHA512";
        if (message.length() < 16) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < 16 - message.length(); ++i) {
                builder.append(0);
            }
            message = builder.append(message).toString();
        }
        byte[] msg = message.getBytes();
        byte[] k = SwordTimeAuthenticator.hexStr2Bytes(key);
        try {
            hash = SwordTimeAuthenticator.hmacSha(crypto, k, msg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SwordRuntimeException("Hmac\u7b97\u6cd5\u914d\u7f6e\u5f02\u5e38");
        }
        int offset = hash[hash.length - 1] & 0xF;
        int binary = (hash[offset] & 0x7F) << 24 | (hash[offset + 1] & 0xFF) << 16 | (hash[offset + 2] & 0xFF) << 8 | hash[offset + 3] & 0xFF;
        int otp = binary % DIGITS_POWER[codeDigits];
        String result = Integer.toString(otp);
        if (result.length() < codeDigits) {
            String format = "%0" + (codeDigits - result.length()) + "d%s";
            result = String.format(format, 0, result);
        }
        return result;
    }

    public static String generateTimeOTP(String key, String message, int codeDigits) {
        return SwordTimeAuthenticator.generateOTP(key, System.currentTimeMillis() / 1800000L + message, codeDigits);
    }

    public static boolean checkTimeOTP(String key, String message, int codeDigits, String code) {
        long time = System.currentTimeMillis() / 1800000L;
        return SwordTimeAuthenticator.generateOTP(key, time + message, codeDigits).equals(code) || SwordTimeAuthenticator.generateOTP(key, time - 1L + message, codeDigits).equals(code);
    }
}

