/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import top.bluesword.util.exception.SwordRuntimeException;

public class OrderedProperties
extends LinkedHashMap<String, String> {
    private List<String> keys = new ArrayList<String>();

    private OrderedProperties() {
    }

    private static List<String> toLines(InputStream input) {
        try {
            String line;
            InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
            BufferedReader bin = new BufferedReader(reader);
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
            return lines;
        }
        catch (IOException e) {
            throw new SwordRuntimeException();
        }
    }

    public String getProperty(String key) {
        return (String)this.get(key);
    }

    public synchronized void load(InputStream inputStream) {
        List<String> lines = OrderedProperties.toLines(inputStream);
        for (String l : lines) {
            if (l.trim().startsWith("#")) {
                this.keys.add(l);
                continue;
            }
            int indexOf = l.indexOf(61);
            if (indexOf > -1) {
                String k = l.substring(0, indexOf).trim();
                String v = l.substring(indexOf + 1).trim();
                this.keys.add(k);
                this.put(k, v);
                continue;
            }
            this.keys.add(l);
        }
    }

    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof OrderedProperties)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

