/*
 * Decompiled with CFR 0.152.
 */
package top.bluesword.util.sequence;

import top.bluesword.util.exception.SwordRuntimeException;

public class Snowflake {
    private static final long START_TIME = 1530258005750L;
    private long workerIdShift;
    private long dataCenterIdShift;
    private long timestampLeftShift;
    private long sequenceMask;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(12L);
    }

    public Snowflake(long sequenceBits) {
        this(0L, 0L, sequenceBits, 0L, 0L);
    }

    public Snowflake(long dataCenterId, long workerId) {
        this(5L, 5L, 12L, dataCenterId, workerId);
    }

    public Snowflake(long workerIdBits, long dataCenterIdBits, long sequenceBits, long dataCenterId, long workerId) {
        long maxDataCenterId = -1L << (int)dataCenterIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        if (dataCenterId > maxDataCenterId || dataCenterId < 0L) {
            throw new SwordRuntimeException(String.format("\u6570\u636e\u4e2d\u5fc3ID\u4e0d\u53ef\u4ee5\u5927\u4e8e  %d \u6216\u5c0f\u4e8e 0", maxDataCenterId));
        }
        long maxWorkerId = -1L << (int)workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        if (workerId > maxWorkerId || workerId < 0L) {
            throw new SwordRuntimeException(String.format("\u5de5\u4f5c\u673a\u5668ID\u4e0d\u53ef\u4ee5\u5927\u4e8e  %d \u6216\u5c0f\u4e8e 0", maxWorkerId));
        }
        this.dataCenterId = dataCenterId;
        this.workerId = workerId;
        this.sequenceMask = -1L << (int)sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.workerIdShift = sequenceBits;
        this.dataCenterIdShift = sequenceBits + workerIdBits;
        this.timestampLeftShift = sequenceBits + workerIdBits + dataCenterIdBits;
    }

    public synchronized Long nextId() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new SwordRuntimeException(String.format("\u65f6\u95f4\u56de\u9000\uff0c\u8bf7\u5728 %d \u6beb\u79d2\u540e\u7533\u8bf7ID", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1530258005750L << (int)this.timestampLeftShift | this.dataCenterId << (int)this.dataCenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

