/*
 * Decompiled with CFR 0.152.
 */
package top.brightk.bridge.process;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import top.brightk.bridge.process.CfNode;
import top.brightk.bridge.process.CsServiceNode;
import top.brightk.bridge.process.NavNode;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u0017\u0010\n\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000b*\u0002H\u000bH\u0002\u00a2\u0006\u0002\u0010\f\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0015\u0010\u000e\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u000b*\u0002H\u000b\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a'\u0010\u0012\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u0013*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0015\u00a2\u0006\u0002\u0010\u0016\u001a\u0019\u0010\u0012\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u0013*\u00020\u0001\u00a2\u0006\u0002\u0010\u0017\u001a\u0010\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019*\u00020\u0001\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019*\u00020\u0001\u001a\u0010\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0019*\u00020\u0001\"\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"toKey", "", "md5", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "Lcom/google/gson/Gson;", "escapeRegex", "Lkotlin/text/Regex;", "underlineRegex", "toJsonStr", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "toEscapeStr", "toTransitContentJson", "formatNodeName", "className2VariableName", "removeUnderline", "parseFromJson", "", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/lang/String;)Ljava/lang/Object;", "getServiceNodes", "", "Ltop/brightk/bridge/process/CsServiceNode;", "getFcNodes", "Ltop/brightk/bridge/process/CfNode;", "getNavNode", "Ltop/brightk/bridge/process/NavNode;", "process"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ntop/brightk/bridge/process/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class UtilsKt {
    private static final Gson gson = new GsonBuilder().create();
    @NotNull
    private static final Regex escapeRegex = new Regex("\"");
    @NotNull
    private static final Regex underlineRegex = new Regex("_[a-zA-Z]");

    @NotNull
    public static final String toKey(@NotNull String $this$toKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"<this>");
        URI url = new URI($this$toKey);
        String string = url.getScheme() + "-" + url.getAuthority() + "-" + url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String md5(@NotNull String $this$md5) {
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        MessageDigest md = MessageDigest.getInstance("MD5");
        String string = $this$md5;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] hashBytes = md.digest(byArray);
        Intrinsics.checkNotNull((Object)hashBytes);
        return ArraysKt.joinToString$default((byte[])hashBytes, (CharSequence)"", null, null, (int)0, null, UtilsKt::md5$lambda$0, (int)30, null);
    }

    private static final <T> String toJsonStr(T $this$toJsonStr) {
        String string = gson.toJson($this$toJsonStr);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    private static final String toEscapeStr(String $this$toEscapeStr) {
        CharSequence charSequence = $this$toEscapeStr;
        Regex regex = escapeRegex;
        Function1 function1 = UtilsKt::toEscapeStr$lambda$1;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final <T> String toTransitContentJson(T $this$toTransitContentJson) {
        return UtilsKt.toEscapeStr(UtilsKt.toJsonStr($this$toTransitContentJson));
    }

    @NotNull
    public static final String formatNodeName(@NotNull String $this$formatNodeName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$formatNodeName, (String)"<this>");
        String string2 = $this$formatNodeName;
        if (((CharSequence)string2).length() > 0) {
            char it = string2.charAt(0);
            boolean bl = false;
            char c = Character.toUpperCase(it);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return UtilsKt.removeUnderline(string);
    }

    @NotNull
    public static final String className2VariableName(@NotNull String $this$className2VariableName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$className2VariableName, (String)"<this>");
        String string2 = $this$className2VariableName;
        if (((CharSequence)string2).length() > 0) {
            char it = string2.charAt(0);
            boolean bl = false;
            char c = Character.toLowerCase(it);
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string3 = string4;
            string = c + string3;
        } else {
            string = string2;
        }
        return string;
    }

    private static final String removeUnderline(String $this$removeUnderline) {
        CharSequence charSequence = $this$removeUnderline;
        Regex regex = underlineRegex;
        Function1 function1 = UtilsKt::removeUnderline$lambda$4;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final <T> T parseFromJson(@NotNull String $this$parseFromJson, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)$this$parseFromJson, (String)"<this>");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Object object = gson.fromJson($this$parseFromJson, clazz);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (T)object;
    }

    @NotNull
    public static final <T> T parseFromJson(@NotNull String $this$parseFromJson) {
        Intrinsics.checkNotNullParameter((Object)$this$parseFromJson, (String)"<this>");
        TypeToken token2 = new TypeToken<T>(){};
        Object object = gson.fromJson($this$parseFromJson, token2.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (T)object;
    }

    @NotNull
    public static final List<CsServiceNode> getServiceNodes(@NotNull String $this$getServiceNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$getServiceNodes, (String)"<this>");
        Object object = gson.fromJson($this$getServiceNodes, new TypeToken<List<? extends CsServiceNode>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (List)object;
    }

    @NotNull
    public static final List<CfNode> getFcNodes(@NotNull String $this$getFcNodes) {
        Intrinsics.checkNotNullParameter((Object)$this$getFcNodes, (String)"<this>");
        Object object = gson.fromJson($this$getFcNodes, new TypeToken<List<? extends CfNode>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (List)object;
    }

    @NotNull
    public static final List<NavNode> getNavNode(@NotNull String $this$getNavNode) {
        Intrinsics.checkNotNullParameter((Object)$this$getNavNode, (String)"<this>");
        Object object = gson.fromJson($this$getNavNode, new TypeToken<List<? extends NavNode>>(){}.getType());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (List)object;
    }

    private static final CharSequence md5$lambda$0(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final CharSequence toEscapeStr$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\\" + it.getValue();
    }

    private static final CharSequence removeUnderline$lambda$4(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = String.valueOf(it.getValue().charAt(1));
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }
}

