/*
 * Decompiled with CFR 0.152.
 */
package top.bughome.monitor.sdk.appender;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import java.util.Arrays;
import top.bughome.monitor.sdk.config.ChannelConfig;
import top.bughome.monitor.sdk.config.KafkaConfig;
import top.bughome.monitor.sdk.config.RedisConfig;
import top.bughome.monitor.sdk.model.LogMessage;
import top.bughome.monitor.sdk.push.IPush;
import top.bughome.monitor.sdk.push.PushConfig;

public class BehaviorMonitorAppender<E>
extends UnsynchronizedAppenderBase<E> {
    private String systemName;
    private String groupId;
    private String channel;
    private KafkaConfig kafkaConfig;
    private RedisConfig redisConfig;
    private IPush push;

    public void start() {
        try {
            if (this.channel == null || this.channel.trim().isEmpty()) {
                this.addError("\u63a8\u9001\u6e20\u9053 channel \u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            this.validateChannelConfig();
            ChannelConfig channelConfig = new ChannelConfig(this.kafkaConfig, this.redisConfig);
            this.push = PushConfig.getPush(this.channel, channelConfig);
            this.addInfo("\u4e1a\u52a1\u884c\u4e3a\u76d1\u63a7\u7ec4\u4ef6\u542f\u52a8\u6210\u529f\uff0c\u63a8\u9001\u6e20\u9053\uff1a" + this.channel);
            super.start();
        }
        catch (Exception e) {
            this.addError("\u4e1a\u52a1\u884c\u4e3a\u76d1\u63a7\u7ec4\u4ef6\u542f\u52a8\u5931\u8d25\uff1a" + e.getMessage(), e);
        }
    }

    protected void append(E eventObject) {
        if (eventObject instanceof ILoggingEvent) {
            ILoggingEvent event = (ILoggingEvent)eventObject;
            String methodName = "unknown";
            String className = "unknown";
            StackTraceElement[] callerData = event.getCallerData();
            if (callerData != null && callerData.length > 0) {
                StackTraceElement element = callerData[0];
                methodName = element.getMethodName();
                className = element.getClassName();
            }
            if (!className.startsWith(this.groupId)) {
                return;
            }
            this.addInfo("**************\u51c6\u5907\u5f00\u59cb\u6267\u884c\u53c2\u6570\u5c01\u88c5******************");
            LogMessage logMessage = new LogMessage(this.systemName, className, methodName, Arrays.asList(event.getFormattedMessage().split(" ")));
            this.push.send(logMessage);
        }
    }

    private void validateChannelConfig() {
        switch (this.channel.toLowerCase()) {
            case "kafka": {
                if (this.kafkaConfig != null) break;
                throw new IllegalStateException("kafkaConfig\u914d\u7f6e\u6709\u8bef");
            }
            case "redis": {
                if (this.redisConfig != null) break;
                throw new IllegalStateException("redisConfig\u914d\u7f6e\u6709\u8bef");
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u63a8\u9001\u6e20\u9053\u7c7b\u578b: " + this.channel);
            }
        }
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public KafkaConfig getKafkaConfig() {
        return this.kafkaConfig;
    }

    public void setKafkaConfig(KafkaConfig kafkaConfig) {
        this.kafkaConfig = kafkaConfig;
    }

    public RedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public void setRedisConfig(RedisConfig redisConfig) {
        this.redisConfig = redisConfig;
    }
}

