/*
 * Decompiled with CFR 0.152.
 */
package top.bughome.monitor.sdk.factory;

import java.util.HashMap;
import org.apache.kafka.common.serialization.StringSerializer;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import top.bughome.monitor.sdk.config.ChannelConfig;
import top.bughome.monitor.sdk.config.KafkaConfig;
import top.bughome.monitor.sdk.config.RedisConfig;
import top.bughome.monitor.sdk.push.IPush;
import top.bughome.monitor.sdk.push.impl.KafkaPush;
import top.bughome.monitor.sdk.push.impl.RedisPush;

public class PushFactory {
    public static IPush createKafkaPush(ChannelConfig channelConfig) {
        KafkaConfig kafkaConfig = channelConfig.getKafkaConfig();
        if (kafkaConfig == null) {
            throw new IllegalStateException("KafkaConfig\u914d\u7f6e\u6709\u8bef");
        }
        if (kafkaConfig.getServers() == null || kafkaConfig.getServers().trim().isEmpty()) {
            throw new IllegalStateException("KafkaConfig \u4e2d\u7684 servers \u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        KafkaTemplate kafkaTemplate = new KafkaTemplate(PushFactory.createKafkaProducerFactory(kafkaConfig));
        return new KafkaPush(kafkaConfig.getTopic(), (KafkaTemplate<String, String>)kafkaTemplate);
    }

    public static IPush createRedisPush(ChannelConfig channelConfig) {
        RedisConfig redisConfig = channelConfig.getRedisConfig();
        if (redisConfig == null) {
            throw new IllegalStateException("RedisConfig\u914d\u7f6e\u6709\u8bef");
        }
        if (redisConfig.getHost() == null || redisConfig.getHost().trim().isEmpty()) {
            throw new IllegalStateException("RedisConfig \u4e2d\u7684 host \u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (redisConfig.getPort() <= 0) {
            throw new IllegalStateException("RedisConfig \u4e2d\u7684 port \u914d\u7f6e\u5fc5\u987b\u5927\u4e8e 0");
        }
        RedissonClient redissonClient = PushFactory.createRedissonClient(redisConfig);
        return new RedisPush(redisConfig.getTopic(), redissonClient);
    }

    private static ProducerFactory<String, String> createKafkaProducerFactory(KafkaConfig kafkaConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", kafkaConfig.getServers());
        props.put("retries", kafkaConfig.getRetries());
        props.put("batch.size", kafkaConfig.getBatchSize());
        props.put("linger.ms", kafkaConfig.getLinger());
        props.put("buffer.memory", kafkaConfig.getBufferMemory());
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", StringSerializer.class);
        return new DefaultKafkaProducerFactory(props);
    }

    private static RedissonClient createRedissonClient(RedisConfig redisConfig) {
        Config config = new Config();
        config.setCodec((Codec)JsonJacksonCodec.INSTANCE);
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress("redis://" + redisConfig.getHost() + ":" + redisConfig.getPort()).setPassword(redisConfig.getPassword())).setConnectionPoolSize(64).setConnectionMinimumIdleSize(10).setIdleConnectionTimeout(1000)).setConnectTimeout(1000)).setRetryAttempts(3)).setRetryInterval(1000)).setPingConnectionInterval(0)).setKeepAlive(true);
        return Redisson.create((Config)config);
    }
}

