/*
 * Decompiled with CFR 0.152.
 */
package top.bughome.monitor.sdk.push;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.bughome.monitor.sdk.config.ChannelConfig;
import top.bughome.monitor.sdk.factory.PushFactory;
import top.bughome.monitor.sdk.push.IPush;

public class PushConfig {
    protected static Map<String, IPush> pushMap = new ConcurrentHashMap<String, IPush>();

    public static IPush getPush(String channel, ChannelConfig channelConfig) {
        return pushMap.computeIfAbsent(channel, k -> switch (channel.toLowerCase()) {
            case "redis" -> PushFactory.createRedisPush(channelConfig);
            case "kafka" -> PushFactory.createKafkaPush(channelConfig);
            default -> throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u63a8\u9001\u6e20\u9053\u7c7b\u578b: " + channel);
        });
    }
}

