/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.aop.DataScope;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.enums.DataPermsScopeEnum;
import top.cenze.interceptor.holder.DataScopeHolder;
import top.cenze.interceptor.pojo.DataScopeContext;
import top.cenze.interceptor.pojo.UserRolePerms;

public abstract class DataScopeAspect {
    private static final Logger log = LoggerFactory.getLogger(DataScopeAspect.class);

    @Pointcut(value="@annotation(top.cenze.interceptor.aop.DataScope)")
    public void cutDataScope() {
        log.info("dataScope ...");
    }

    @Before(value="cutDataScope()")
    public void beforeDataScope(JoinPoint joinPoint) {
        log.info("beforeDataScope ...");
        DataScopeContext dataScope = this.getDataScopeContext(joinPoint);
        log.info("aroundDataScope dataScope: {}", (Object)JSON.toJSONString((Object)dataScope));
        if (ObjectUtil.isNotNull((Object)dataScope)) {
            DataScopeHolder.setDataScope(dataScope);
        }
    }

    @After(value="cutDataScope()")
    public void afterDataScope() {
        log.info("afterDataScope ...");
        DataScopeHolder.clearDataScope();
    }

    private List<DataPermsScopeEnum> getAnnotationIgnoreScopes(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        DataScope dataScope = method.getAnnotation(DataScope.class);
        DataPermsScopeEnum[] ignoreScopes = dataScope.ignoreScopes();
        if (ObjectUtil.isNotNull((Object)ignoreScopes) && ignoreScopes.length > 0) {
            return new ArrayList<DataPermsScopeEnum>(Arrays.asList(ignoreScopes));
        }
        return null;
    }

    private List<String> getAnnotationIgnoreTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        DataScope dataScope = method.getAnnotation(DataScope.class);
        if (ObjectUtil.isNull((Object)dataScope)) {
            return null;
        }
        String[] ignoreTables = dataScope.ignoreTables();
        if (ObjectUtil.isNotNull((Object)ignoreTables) && ignoreTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(ignoreTables));
        }
        return null;
    }

    private List<String> getAnnotationIncludeTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        DataScope dataScope = method.getAnnotation(DataScope.class);
        if (ObjectUtil.isNull((Object)dataScope)) {
            return null;
        }
        String[] includeTables = dataScope.includeTables();
        if (ObjectUtil.isNotNull((Object)includeTables) && includeTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(includeTables));
        }
        return null;
    }

    private DataScopeContext getDataScopeContext(JoinPoint point) {
        List<String> annotationIgnoreTables = this.getAnnotationIgnoreTables(point);
        DataScopeHolder.setAopIgnoreTableNames(annotationIgnoreTables);
        List<String> annotationIncludeTables = this.getAnnotationIncludeTables(point);
        DataScopeHolder.setAopIncludeTableNames(annotationIncludeTables);
        UserRolePerms userRolePerms = this.getUserRolePerms(point);
        log.info("getDataScopeContext userRolePerms: {}", (Object)JSON.toJSONString((Object)userRolePerms));
        if (ObjectUtil.isNull((Object)userRolePerms)) {
            return null;
        }
        DataPermsScopeEnum dataScope = userRolePerms.getDataPermsScope();
        if (ObjectUtil.isNull((Object)((Object)dataScope))) {
            return null;
        }
        if (!this.dataScopeCloumnExist(dataScope)) {
            return null;
        }
        List<DataPermsScopeEnum> annotationIgnoreScopes = this.getAnnotationIgnoreScopes(point);
        if (CollectionUtil.isNotEmpty(annotationIgnoreScopes) && annotationIgnoreScopes.contains((Object)dataScope)) {
            return null;
        }
        DataScopeContext dataScopeContext = new DataScopeContext();
        dataScopeContext.setDataScope(dataScope);
        dataScopeContext.setUserId(userRolePerms.getUserId());
        if (ObjectUtil.isNotNull((Object)userRolePerms.getCompanyId()) && userRolePerms.getCompanyId().equals(0L)) {
            userRolePerms.setCompanyId(null);
        }
        dataScopeContext.setCompanyId(userRolePerms.getCompanyId());
        if (ObjectUtil.isNotNull((Object)userRolePerms.getDepartmentId()) && userRolePerms.getDepartmentId().equals(0L)) {
            userRolePerms.setDepartmentId(null);
        }
        dataScopeContext.setDepartmentId(userRolePerms.getDepartmentId());
        switch (dataScope) {
            case ADMIN: {
                break;
            }
            case PLAT: {
                break;
            }
            case OWNR: {
                dataScopeContext.set(DataPermsCloumnEnum.CREATE_BY_ID, Convert.toStr((Object)userRolePerms.getUserId()));
                break;
            }
            case CRTY: {
                dataScopeContext.set(DataPermsCloumnEnum.CREATE_BY_ID, userRolePerms.getCreateByIds());
                break;
            }
            case DEPT: {
                dataScopeContext.set(DataPermsCloumnEnum.DEPARTMENT_ID, userRolePerms.getDepartmentIds());
                break;
            }
            case CMPY: {
                dataScopeContext.set(DataPermsCloumnEnum.COMPANY_ID, userRolePerms.getCompanyIds());
                break;
            }
            default: {
                dataScopeContext.set(DataPermsCloumnEnum.COMPANY_ID, userRolePerms.getCompanyIds());
            }
        }
        log.info("getDataScopeContext dataScopeContext: {}", (Object)JSON.toJSONString((Object)dataScopeContext));
        return dataScopeContext;
    }

    private boolean dataScopeCloumnExist(DataPermsScopeEnum e) {
        switch (e) {
            case ADMIN: {
                return false;
            }
            case PLAT: {
                return false;
            }
            case OWNR: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.CREATE_BY_ID);
            }
            case CRTY: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.CREATE_BY_ID);
            }
            case DEPT: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.DEPARTMENT_ID);
            }
            case CMPY: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.COMPANY_ID);
            }
        }
        return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.COMPANY_ID);
    }

    public abstract UserRolePerms getUserRolePerms(JoinPoint var1);
}

