/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.mybatis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.DesensitizedUtil;
import cn.hutool.core.util.ObjectUtil;
import java.lang.reflect.Field;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ibatis.executor.resultset.ResultSetHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.aop.FieldSensitive;
import top.cenze.interceptor.holder.SensitiveHolder;
import top.cenze.interceptor.utils.AspectUtil;

@Intercepts(value={@Signature(type=ResultSetHandler.class, method="handleResultSets", args={Statement.class})})
public class SensitiveInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SensitiveInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Boolean sensitive = SensitiveHolder.getSensitive();
        Object resultObject = invocation.proceed();
        if (ObjectUtil.isNotNull((Object)sensitive) && sensitive.booleanValue() && ObjectUtil.isNotNull((Object)resultObject)) {
            if (resultObject instanceof ArrayList) {
                ArrayList resultList = (ArrayList)resultObject;
                if (CollectionUtil.isNotEmpty((Collection)resultList)) {
                    for (Object result : resultList) {
                        this.sensitive(result);
                    }
                }
            } else {
                this.sensitive(resultObject);
            }
        }
        return resultObject;
    }

    private void sensitive(Object result) {
        if (AspectUtil.isJavaLang(result)) {
            return;
        }
        ArrayList<Field> lstField = new ArrayList<Field>();
        Class<?> clazz = result.getClass();
        if (ObjectUtil.isNotNull(clazz)) {
            Field[] clazzFields = clazz.getDeclaredFields();
            lstField.addAll(Arrays.asList(clazzFields));
            Class<?> superClazz = clazz.getSuperclass();
            if (ObjectUtil.isNotNull(superClazz)) {
                Field[] superFields = superClazz.getDeclaredFields();
                lstField.addAll(Arrays.asList(superFields));
            }
        }
        if (CollectionUtil.isEmpty(lstField)) {
            return;
        }
        for (Field field : lstField) {
            FieldSensitive sensitiveAnnotation = field.getDeclaredAnnotation(FieldSensitive.class);
            if (!ObjectUtil.isNotNull((Object)sensitiveAnnotation)) continue;
            field.setAccessible(true);
            Object obj = field.get(result);
            if (!(obj instanceof String)) continue;
            String value = (String)obj;
            value = DesensitizedUtil.desensitized((CharSequence)value, (DesensitizedUtil.DesensitizedType)sensitiveAnnotation.type());
            log.info("sensitive val: {}", (Object)value);
            field.set(result, value);
        }
    }
}

