/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.mybatis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.holder.TenantHolder;

public class TenantInterceptor
implements TenantLineHandler {
    private static final Logger log = LoggerFactory.getLogger(TenantInterceptor.class);

    public Expression getTenantId() {
        Long tenantId = TenantHolder.getTenantId();
        log.info("getTenantId tenantId: {}", (Object)tenantId);
        if (ObjectUtil.isNotNull((Object)tenantId)) {
            return new LongValue(tenantId.longValue());
        }
        return new NullValue();
    }

    public String getTenantIdColumn() {
        return TenantHolder.getTenantColumnName();
    }

    public boolean ignoreTable(String mainTableName) {
        log.info("ignoreTable mainTableName: {}", (Object)mainTableName);
        if (!DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.TENANT_ID)) {
            return true;
        }
        if (ObjectUtil.isNull((Object)mainTableName)) {
            return true;
        }
        List<String> aopIgnoreTableNames = TenantHolder.getAopIgnoreTableNames();
        log.info("ignoreTable aopIgnoreTableNames: {}", (Object)JSON.toJSONString(aopIgnoreTableNames));
        if (CollectionUtil.isNotEmpty(aopIgnoreTableNames) && aopIgnoreTableNames.contains(mainTableName)) {
            return true;
        }
        List<String> ymlIgnoreTableNames = TenantHolder.getYmlIgnoreTableNames();
        log.info("ignoreTable ymlIgnoreTableNames: {}", (Object)JSON.toJSONString(ymlIgnoreTableNames));
        if (CollectionUtil.isNotEmpty(ymlIgnoreTableNames) && ymlIgnoreTableNames.contains(mainTableName)) {
            return true;
        }
        List<String> aopIncludeTableNames = TenantHolder.getAopIncludeTableNames();
        log.info("ignoreTable aopIncludeTableNames: {}", (Object)JSON.toJSONString(aopIncludeTableNames));
        if (CollectionUtil.isNotEmpty(aopIncludeTableNames) && !aopIncludeTableNames.contains(mainTableName)) {
            return true;
        }
        List<String> ymlIncludeTableNames = TenantHolder.getYmlIncludeTableNames();
        log.info("ignoreTable ymlIncludeTableNames: {}", (Object)JSON.toJSONString(ymlIncludeTableNames));
        if (CollectionUtil.isNotEmpty(ymlIncludeTableNames) && !ymlIncludeTableNames.contains(mainTableName)) {
            return true;
        }
        Long tenantId = TenantHolder.getTenantId();
        log.info("ignoreTable tenantId: {}", (Object)tenantId);
        if (ObjectUtil.isNull((Object)tenantId)) {
            return true;
        }
        log.info("ignoreTable: {}", (Object)"false");
        return false;
    }
}

