/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.aspect;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.aop.MultiTenant;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.enums.DataPermsScopeEnum;
import top.cenze.interceptor.holder.TenantHolder;
import top.cenze.interceptor.pojo.UserRolePerms;

public abstract class TenantAspect {
    private static final Logger log = LoggerFactory.getLogger(TenantAspect.class);

    @Pointcut(value="@annotation(top.cenze.interceptor.aop.MultiTenant)")
    public void cutTenant() {
        log.info("tenant ...");
    }

    @Before(value="cutTenant()")
    public void beforeTenant(JoinPoint point) {
        log.info("beforeTenant ...");
        Long tenantId = this.getTenantId(point);
        log.info("beforeTenant tenant id: {}", (Object)tenantId);
        if (ObjectUtil.isNotNull((Object)tenantId)) {
            TenantHolder.setTenantId(tenantId);
            List<String> annotationIgnoreTables = this.getAnnotationIgnoreTables(point);
            log.info("beforeTenant annotationIgnoreTables: {}", (Object)JSON.toJSONString(annotationIgnoreTables));
            TenantHolder.setAopIgnoreTableNames(annotationIgnoreTables);
            List<String> annotationIncludeTables = this.getAnnotationIncludeTables(point);
            log.info("beforeTenant annotationIncludeTables: {}", (Object)JSON.toJSONString(annotationIncludeTables));
            TenantHolder.setAopIncludeTableNames(annotationIncludeTables);
        }
    }

    @After(value="cutTenant()")
    public void afterTenant() {
        log.info("afterTenant ...");
        TenantHolder.clearTenant();
    }

    private List<String> getAnnotationIgnoreTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        MultiTenant multiTenant = method.getAnnotation(MultiTenant.class);
        if (ObjectUtil.isNull((Object)multiTenant)) {
            return null;
        }
        String[] ignoreTables = multiTenant.ignoreTables();
        log.info("getAnnotationIgnoreTables ignoreTables: {}", (Object)JSON.toJSONString((Object)ignoreTables));
        if (ObjectUtil.isNotNull((Object)ignoreTables) && ignoreTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(ignoreTables));
        }
        return null;
    }

    private List<String> getAnnotationIncludeTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        MultiTenant multiTenant = method.getAnnotation(MultiTenant.class);
        if (ObjectUtil.isNull((Object)multiTenant)) {
            return null;
        }
        String[] includeTables = multiTenant.includeTables();
        log.info("getAnnotationIncludeTables includeTables: {}", (Object)JSON.toJSONString((Object)includeTables));
        if (ObjectUtil.isNotNull((Object)includeTables) && includeTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(includeTables));
        }
        return null;
    }

    private Long getTenantId(JoinPoint point) {
        UserRolePerms userRolePerms = this.getUserRolePerms(point);
        log.info("getTenantId userRolePerms: {}", (Object)JSON.toJSONString((Object)userRolePerms));
        if (ObjectUtil.isNull((Object)userRolePerms) || ObjectUtil.isNull((Object)userRolePerms.getTenantId())) {
            return null;
        }
        if (!DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.TENANT_ID)) {
            return null;
        }
        if (ObjectUtil.isNotNull((Object)((Object)userRolePerms.getDataPermsScope())) && DataPermsScopeEnum.ADMIN.equals((Object)userRolePerms.getDataPermsScope()) || ObjectUtil.isNotNull((Object)userRolePerms.getIsAdmin()) && userRolePerms.getIsAdmin().booleanValue()) {
            return null;
        }
        return userRolePerms.getTenantId();
    }

    public abstract UserRolePerms getUserRolePerms(JoinPoint var1);
}

