/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.holder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.enums.DataPermsScopeEnum;
import top.cenze.interceptor.pojo.DataScopeContext;

public class DataScopeHolder {
    private static final Logger log = LoggerFactory.getLogger(DataScopeHolder.class);
    private static final ThreadLocal<DataScopeContext> DATA_SCOPE_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> MAIN_TABLE_ALIA_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> MAIN_TABLE_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final List<String> YML_IGNORE_TABLE_NAMES = new ArrayList<String>();
    private static final List<String> YML_INCLUDE_TABLE_NAMES = new ArrayList<String>();
    private static final ThreadLocal<List<String>> AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<List<String>> AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();

    public static void setDataScope(DataScopeContext context) {
        log.info("setDataScope context: {}", (Object)JSON.toJSONString((Object)context));
        DATA_SCOPE_CONTEXT_THREAD_LOCAL.set(context);
    }

    public static DataScopeContext getDataScope() {
        DataScopeContext dataScopeContext = DATA_SCOPE_CONTEXT_THREAD_LOCAL.get();
        log.info("getDataScope context: {}", (Object)JSON.toJSONString((Object)dataScopeContext));
        return dataScopeContext;
    }

    public static void setMainTable(String tableName) {
        log.info("setMainTable aliaName: {}", (Object)tableName);
        MAIN_TABLE_ALIA_NAME_THREAD_LOCAL.set(tableName);
    }

    public static String getMainTable() {
        String tableName = MAIN_TABLE_ALIA_NAME_THREAD_LOCAL.get();
        log.info("getMainTable aliaName: {}", (Object)tableName);
        MAIN_TABLE_ALIA_NAME_THREAD_LOCAL.remove();
        return tableName;
    }

    public static void setMainTableName(String tableName) {
        log.info("setMainTable tableName: {}", (Object)tableName);
        MAIN_TABLE_NAME_THREAD_LOCAL.set(tableName);
    }

    public static String getMainTableName() {
        String tableName = MAIN_TABLE_NAME_THREAD_LOCAL.get();
        log.info("getMainTable tableName: {}", (Object)tableName);
        MAIN_TABLE_NAME_THREAD_LOCAL.remove();
        return tableName;
    }

    public static void setYmlIgnoreTableNames(List<String> tableNames) {
        log.info("setIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_IGNORE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIgnoreTableNames() {
        return YML_IGNORE_TABLE_NAMES;
    }

    public static void setYmlIncludeTableNames(List<String> tableNames) {
        log.info("setYmlIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_INCLUDE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIncludeTableNames() {
        return YML_INCLUDE_TABLE_NAMES;
    }

    public static void setAopIgnoreTableNames(List<String> tableNames) {
        log.info("setAopIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIgnoreTableNames() {
        return AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void setAopIncludeTableNames(List<String> tableNames) {
        log.info("setAopIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIncludeTableNames() {
        return AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void clearDataScope() {
        MAIN_TABLE_ALIA_NAME_THREAD_LOCAL.remove();
        MAIN_TABLE_NAME_THREAD_LOCAL.remove();
        DATA_SCOPE_CONTEXT_THREAD_LOCAL.remove();
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.remove();
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.remove();
    }

    private static Expression getSubExpression(DataPermsScopeEnum scopeEnum, Expression where, String mainTableName, String columnName, Long id) {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(id);
        return DataScopeHolder.getSubExpression(scopeEnum, where, mainTableName, columnName, ids, 0);
    }

    private static Expression getSubExpression(DataPermsScopeEnum scopeEnum, Expression where, String mainTableName, String columnName, List<Long> ids) {
        return DataScopeHolder.getSubExpression(scopeEnum, where, mainTableName, columnName, ids, null);
    }

    private static Expression getSubExpression(DataPermsScopeEnum scopeEnum, Expression where, String mainTableName, String columnName, List<Long> ids, Integer index) {
        if (CollectionUtil.isEmpty(ids)) {
            return where;
        }
        if (ObjectUtil.isNull((Object)index) && 1 == ids.size()) {
            index = 0;
        }
        columnName = DataScopeHolder.getColumnName(mainTableName, columnName);
        Object exp = null;
        exp = ObjectUtil.isNotNull((Object)index) && index.equals(0) ? DataScopeHolder.getEqualLong(columnName, ids.get(0)) : DataScopeHolder.getInLongList(columnName, ids);
        if (ObjectUtil.isNotNull((Object)exp)) {
            if (ObjectUtil.isNotNull((Object)where)) {
                AndExpression ownrExp = new AndExpression();
                ownrExp.setLeftExpression(where);
                ownrExp.setRightExpression((Expression)exp);
                return ownrExp;
            }
            return exp;
        }
        return where;
    }

    private static EqualsTo getEqualLong(String columnName, Long value) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(columnName));
        equalsTo.setRightExpression((Expression)new LongValue(value.longValue()));
        return equalsTo;
    }

    private static InExpression getInLongList(String columnName, List<Long> ids) {
        ExpressionList itemsList = new ExpressionList(ids.stream().map(LongValue::new).collect(Collectors.toList()));
        InExpression inExpression = new InExpression((Expression)new Column(columnName), (ItemsList)itemsList);
        return inExpression;
    }

    private static EqualsTo getEqualString(String columnName, String value) {
        EqualsTo equalsTo = new EqualsTo();
        equalsTo.setLeftExpression((Expression)new Column(columnName));
        equalsTo.setRightExpression((Expression)new StringValue(value));
        return equalsTo;
    }

    private static String getColumnName(String mainTableName, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(mainTableName).append(".").append(columnName).append(" ");
        return sb.toString();
    }

    public static Expression getSqlSegment(Expression where) {
        String tableName = DataScopeHolder.getMainTableName();
        if (StrUtil.isEmpty((CharSequence)tableName)) {
            return where;
        }
        List<String> aopIgnoreTableNames = DataScopeHolder.getAopIgnoreTableNames();
        if (CollectionUtil.isNotEmpty(aopIgnoreTableNames) && aopIgnoreTableNames.contains(tableName)) {
            return where;
        }
        List<String> ymlIgnoreTableNames = DataScopeHolder.getYmlIgnoreTableNames();
        if (CollectionUtil.isNotEmpty(ymlIgnoreTableNames) && ymlIgnoreTableNames.contains(tableName)) {
            return where;
        }
        List<String> aopIncludeTableNames = DataScopeHolder.getAopIncludeTableNames();
        if (CollectionUtil.isNotEmpty(aopIncludeTableNames) && !aopIgnoreTableNames.contains(aopIncludeTableNames)) {
            return where;
        }
        List<String> ymlIncludeTableNames = DataScopeHolder.getYmlIncludeTableNames();
        if (CollectionUtil.isNotEmpty(ymlIncludeTableNames) && !ymlIncludeTableNames.contains(tableName)) {
            return where;
        }
        DataScopeContext dataScopeContext = DataScopeHolder.getDataScope();
        log.debug("getSqlSegment dataScopeContext: {}", (Object)JSON.toJSONString((Object)dataScopeContext));
        if (ObjectUtil.isNull((Object)dataScopeContext)) {
            return where;
        }
        String mainTableName = DataScopeHolder.getMainTable();
        log.info("getSqlSegment mainTableName: {}", (Object)mainTableName);
        Expression exp = where;
        DataPermsScopeEnum scopeEnum = dataScopeContext.getDataScope();
        switch (scopeEnum) {
            case ADMIN: {
                break;
            }
            case PLAT: {
                break;
            }
            case OWNR: {
                if (!ObjectUtil.isNotNull((Object)dataScopeContext.getUserId())) break;
                exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.OWNR, exp, mainTableName, DataPermsCloumnEnum.CREATE_BY_ID.getCloumnName(), dataScopeContext.getUserId());
                break;
            }
            case CRTY: {
                if (CollectionUtil.isNotEmpty(dataScopeContext.getCreateByIds())) {
                    exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.CRTY, exp, mainTableName, DataPermsCloumnEnum.CREATE_BY_ID.getCloumnName(), dataScopeContext.getCreateByIds());
                    break;
                }
                if (!ObjectUtil.isNotNull((Object)dataScopeContext.getUserId())) break;
                exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.CRTY, exp, mainTableName, DataPermsCloumnEnum.CREATE_BY_ID.getCloumnName(), dataScopeContext.getUserId());
                break;
            }
            case DEPT: {
                if (CollectionUtil.isNotEmpty(dataScopeContext.getDepartmentIds())) {
                    exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.DEPT, exp, mainTableName, DataPermsCloumnEnum.DEPARTMENT_ID.getCloumnName(), dataScopeContext.getDepartmentIds());
                    break;
                }
                if (!ObjectUtil.isNotNull((Object)dataScopeContext.getDepartmentId())) break;
                exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.DEPT, exp, mainTableName, DataPermsCloumnEnum.DEPARTMENT_ID.getCloumnName(), dataScopeContext.getDepartmentId());
                break;
            }
            case CMPY: {
                if (CollectionUtil.isNotEmpty(dataScopeContext.getCompanyIds())) {
                    exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.CMPY, exp, mainTableName, DataPermsCloumnEnum.COMPANY_ID.getCloumnName(), dataScopeContext.getCompanyIds());
                    break;
                }
                if (!ObjectUtil.isNotNull((Object)dataScopeContext.getCompanyId())) break;
                exp = DataScopeHolder.getSubExpression(DataPermsScopeEnum.CMPY, exp, mainTableName, DataPermsCloumnEnum.COMPANY_ID.getCloumnName(), dataScopeContext.getCompanyId());
                break;
            }
        }
        log.info("getSqlSegment exp: {}", (Object)exp);
        return exp;
    }
}

