/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.config;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.holder.DataScopeHolder;
import top.cenze.interceptor.holder.TenantHolder;
import top.cenze.interceptor.mybatis.DataPermInterceptor;
import top.cenze.interceptor.mybatis.SensitiveInterceptor;
import top.cenze.interceptor.mybatis.TenantInterceptor;

public abstract class CenZeMybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(CenZeMybatisPlusConfig.class);

    public CenZeMybatisPlusConfig(String tenantIdColumnName) {
        TenantHolder.setYmlIgnoreTableNames(null);
        TenantHolder.setYmlIncludeTableNames(null);
        DataScopeHolder.setYmlIgnoreTableNames(null);
        DataScopeHolder.setYmlIncludeTableNames(null);
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(null);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(null);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(null);
    }

    public CenZeMybatisPlusConfig(String tenantIdColumnName, String companyIdColumnName, String departmentIdColumnName, String createByIdColumnName) {
        TenantHolder.setYmlIgnoreTableNames(null);
        TenantHolder.setYmlIncludeTableNames(null);
        DataScopeHolder.setYmlIgnoreTableNames(null);
        DataScopeHolder.setYmlIncludeTableNames(null);
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(companyIdColumnName);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(departmentIdColumnName);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(createByIdColumnName);
    }

    public CenZeMybatisPlusConfig(String tenantIgnoreTableNames, String tenantIncludeTableNames, String tenantIdColumnName, String datascopeIgnoreTableNames, String datascopeIncludeTableNames, String companyIdColumnName, String departmentIdColumnName, String createByIdColumnName) {
        List lstDataScopeIncludeTableName;
        List lstDataScopeIgnoreTableName;
        List lstTenantIncludeTableName;
        List lstTenantIgnoreTableName;
        if (StrUtil.isNotEmpty((CharSequence)tenantIgnoreTableNames) && CollectionUtil.isNotEmpty((Collection)(lstTenantIgnoreTableName = StrUtil.split((CharSequence)tenantIgnoreTableNames, (CharSequence)",")))) {
            TenantHolder.setYmlIgnoreTableNames(lstTenantIgnoreTableName);
        }
        if (StrUtil.isNotEmpty((CharSequence)tenantIncludeTableNames) && CollectionUtil.isNotEmpty((Collection)(lstTenantIncludeTableName = StrUtil.split((CharSequence)tenantIncludeTableNames, (CharSequence)",")))) {
            TenantHolder.setYmlIncludeTableNames(lstTenantIncludeTableName);
        }
        if (StrUtil.isNotEmpty((CharSequence)datascopeIgnoreTableNames) && CollectionUtil.isNotEmpty((Collection)(lstDataScopeIgnoreTableName = StrUtil.split((CharSequence)datascopeIgnoreTableNames, (CharSequence)",")))) {
            DataScopeHolder.setYmlIgnoreTableNames(lstDataScopeIgnoreTableName);
        }
        if (StrUtil.isNotEmpty((CharSequence)datascopeIncludeTableNames) && CollectionUtil.isNotEmpty((Collection)(lstDataScopeIncludeTableName = StrUtil.split((CharSequence)datascopeIncludeTableNames, (CharSequence)",")))) {
            DataScopeHolder.setYmlIncludeTableNames(lstDataScopeIncludeTableName);
        }
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(companyIdColumnName);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(departmentIdColumnName);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(createByIdColumnName);
    }

    @Bean
    public Boolean setAutoFillValueInterceptor(SqlSessionFactory sqlSessionFactory) {
        Configuration configuration = sqlSessionFactory.getConfiguration();
        configuration.addInterceptor((Interceptor)new SensitiveInterceptor());
        return Boolean.TRUE;
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.tenantLineInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.dataPermissionInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)this.paginationInnerInterceptor());
        return interceptor;
    }

    public PaginationInnerInterceptor paginationInnerInterceptor() {
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(-1L));
        return paginationInnerInterceptor;
    }

    public DataPermissionInterceptor dataPermissionInterceptor() {
        DataPermInterceptor dataPermissionInterceptor = new DataPermInterceptor();
        dataPermissionInterceptor.setDataPermissionHandler(new DataPermissionHandler(){

            public Expression getSqlSegment(Expression where, String mappedStatementId) {
                return DataScopeHolder.getSqlSegment(where);
            }
        });
        return dataPermissionInterceptor;
    }

    public TenantLineInnerInterceptor tenantLineInnerInterceptor() {
        return new TenantLineInnerInterceptor((TenantLineHandler)new TenantInterceptor());
    }
}

