/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.holder;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;

public class TenantHolder {
    private static final Logger log = LoggerFactory.getLogger(TenantHolder.class);
    private static final List<String> YML_IGNORE_TABLE_NAMES = new ArrayList<String>();
    private static final List<String> YML_INCLUDE_TABLE_NAMES = new ArrayList<String>();
    private static final ThreadLocal<Long> TENANT_ID_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<List<String>> AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<List<String>> AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();

    public static Long getTenantId() {
        Long tenantId = TENANT_ID_THREAD_LOCAL.get();
        log.info("getTenantId tenantId: {}", (Object)tenantId);
        return tenantId;
    }

    public static void setTenantId(Long tenantId) {
        log.info("setTenant tenantId: {}", (Object)tenantId);
        TENANT_ID_THREAD_LOCAL.set(tenantId);
    }

    public static String getTenantColumnName() {
        return DataPermsCloumnEnum.TENANT_ID.getCloumnName();
    }

    public static void setYmlIgnoreTableNames(List<String> tableNames) {
        log.info("setIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_IGNORE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIgnoreTableNames() {
        return YML_IGNORE_TABLE_NAMES;
    }

    public static void setYmlIncludeTableNames(List<String> tableNames) {
        log.info("setYmlIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_INCLUDE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIncludeTableNames() {
        return YML_INCLUDE_TABLE_NAMES;
    }

    public static void setAopIgnoreTableNames(List<String> tableNames) {
        log.info("setAopIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIgnoreTableNames() {
        return AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void setAopIncludeTableNames(List<String> tableNames) {
        log.info("setAopIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIncludeTableNames() {
        return AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void clearTenant() {
        TENANT_ID_THREAD_LOCAL.remove();
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.remove();
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.remove();
    }
}

