/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.aspect;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.cenze.interceptor.aop.CenzeDataPrems;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.enums.DataPermsEnum;
import top.cenze.interceptor.holder.DataPermsHolder;
import top.cenze.interceptor.pojo.DataPermsContext;
import top.cenze.interceptor.pojo.UserRolePerms;
import top.cenze.interceptor.service.CenzeUserRolePermsService;

@Aspect
@Component
public class CenzeDataPremsAspect {
    private static final Logger log = LoggerFactory.getLogger(CenzeDataPremsAspect.class);
    private final CenzeUserRolePermsService cenzeUserRolePermsService;

    public CenzeDataPremsAspect(CenzeUserRolePermsService userRolePermsService) {
        this.cenzeUserRolePermsService = userRolePermsService;
    }

    @Pointcut(value="@annotation(top.cenze.interceptor.aop.CenzeDataPrems)")
    public void cutDataPrems() {
        log.info("dataPrems ...");
    }

    @Before(value="cutDataPrems()")
    public void beforeDataPrems(JoinPoint joinPoint) {
        log.info("beforeDataPrems ...");
        DataPermsContext dataPrems = this.getDataPermsContext(joinPoint);
        log.info("aroundDataPrems dataPrems: {}", (Object)JSON.toJSONString((Object)dataPrems));
        if (ObjectUtil.isNotNull((Object)dataPrems)) {
            DataPermsHolder.setDataScope(dataPrems);
        }
    }

    @After(value="cutDataPrems()")
    public void afterDataPrems() {
        log.info("afterDataPrems ...");
        DataPermsHolder.clearDataScope();
    }

    private List<DataPermsEnum> getAnnotationIgnoreScopes(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        CenzeDataPrems dataScope = method.getAnnotation(CenzeDataPrems.class);
        DataPermsEnum[] ignoreScopes = dataScope.ignorePerms();
        if (ObjectUtil.isNotNull((Object)ignoreScopes) && ignoreScopes.length > 0) {
            return new ArrayList<DataPermsEnum>(Arrays.asList(ignoreScopes));
        }
        return null;
    }

    private List<DataPermsEnum> getAnnotationIncludeScopes(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        CenzeDataPrems dataScope = method.getAnnotation(CenzeDataPrems.class);
        DataPermsEnum[] includeScopes = dataScope.includePerms();
        if (ObjectUtil.isNotNull((Object)includeScopes) && includeScopes.length > 0) {
            return new ArrayList<DataPermsEnum>(Arrays.asList(includeScopes));
        }
        return null;
    }

    private List<String> getAnnotationIgnoreTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        CenzeDataPrems dataScope = method.getAnnotation(CenzeDataPrems.class);
        if (ObjectUtil.isNull((Object)dataScope)) {
            return null;
        }
        String[] ignoreTables = dataScope.ignoreTables();
        if (ObjectUtil.isNotNull((Object)ignoreTables) && ignoreTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(ignoreTables));
        }
        return null;
    }

    private List<String> getAnnotationIncludeTables(JoinPoint point) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        CenzeDataPrems dataScope = method.getAnnotation(CenzeDataPrems.class);
        if (ObjectUtil.isNull((Object)dataScope)) {
            return null;
        }
        String[] includeTables = dataScope.includeTables();
        if (ObjectUtil.isNotNull((Object)includeTables) && includeTables.length > 0) {
            return new ArrayList<String>(Arrays.asList(includeTables));
        }
        return null;
    }

    private DataPermsContext getDataPermsContext(JoinPoint point) {
        DataPermsEnum dataScope;
        List<String> annotationIgnoreTables = this.getAnnotationIgnoreTables(point);
        DataPermsHolder.setAopIgnoreTableNames(annotationIgnoreTables);
        List<String> annotationIncludeTables = this.getAnnotationIncludeTables(point);
        DataPermsHolder.setAopIncludeTableNames(annotationIncludeTables);
        List<DataPermsEnum> lstIncludePrems = this.getAnnotationIncludeScopes(point);
        UserRolePerms userRolePerms = this.cenzeUserRolePermsService.getUserRolePerms(point);
        log.info("getDataPermsContext userRolePerms: {}", (Object)JSON.toJSONString((Object)userRolePerms));
        if (ObjectUtil.isNull((Object)userRolePerms)) {
            return null;
        }
        if (ObjectUtil.isNotNull((Object)userRolePerms.getAdmin())) {
            if (userRolePerms.getAdmin().booleanValue()) {
                return null;
            }
            if (ObjectUtil.isNull((Object)userRolePerms.getTenantId())) {
                return null;
            }
        }
        if (ObjectUtil.isNotNull((Object)((Object)(dataScope = userRolePerms.getDataPermsScope())))) {
            if (CollectionUtil.isEmpty(lstIncludePrems)) {
                lstIncludePrems = new ArrayList<DataPermsEnum>();
            }
            lstIncludePrems.add(dataScope);
            if (!DataPermsEnum.PLAT.equals((Object)dataScope)) {
                lstIncludePrems.add(DataPermsEnum.PLAT);
            }
        }
        if (CollectionUtil.isNotEmpty(lstIncludePrems = lstIncludePrems.stream().distinct().collect(Collectors.toList()))) {
            for (Object scope : lstIncludePrems) {
                if (this.dataPermsCloumnExist((DataPermsEnum)((Object)scope))) continue;
                return null;
            }
        }
        if (CollectionUtil.isEmpty(lstIncludePrems)) {
            return null;
        }
        List<DataPermsEnum> lstIgnorePrems = this.getAnnotationIgnoreScopes(point);
        if (CollectionUtil.isNotEmpty(lstIgnorePrems)) {
            for (DataPermsEnum prem : lstIgnorePrems) {
                if (!lstIncludePrems.contains((Object)prem)) continue;
                lstIncludePrems.remove((Object)prem);
            }
        }
        if (CollectionUtil.isEmpty(lstIncludePrems)) {
            return null;
        }
        DataPermsContext dataPermsContext = new DataPermsContext();
        dataPermsContext.setDataScope(lstIncludePrems);
        dataPermsContext.setTenantId(userRolePerms.getTenantId());
        dataPermsContext.setUserId(userRolePerms.getUserId());
        dataPermsContext.setCreateById(userRolePerms.getUserId());
        if (ObjectUtil.isNotNull((Object)userRolePerms.getCompanyId()) && userRolePerms.getCompanyId().equals(0L)) {
            userRolePerms.setCompanyId(null);
        }
        if (ObjectUtil.isNotNull((Object)userRolePerms.getDepartmentId()) && userRolePerms.getDepartmentId().equals(0L)) {
            userRolePerms.setDepartmentId(null);
        }
        dataPermsContext.setValue(DataPermsCloumnEnum.COMPANY_ID, userRolePerms.getCompanyId());
        dataPermsContext.setSubValues(DataPermsCloumnEnum.COMPANY_ID, userRolePerms.getSubCompanyIds());
        dataPermsContext.setAllValues(DataPermsCloumnEnum.COMPANY_ID, userRolePerms.getAllCompanyIds());
        dataPermsContext.setValue(DataPermsCloumnEnum.DEPARTMENT_ID, userRolePerms.getDepartmentId());
        dataPermsContext.setSubValues(DataPermsCloumnEnum.DEPARTMENT_ID, userRolePerms.getSubDepartmentIds());
        dataPermsContext.setAllValues(DataPermsCloumnEnum.DEPARTMENT_ID, userRolePerms.getAllDepartmentIds());
        dataPermsContext.setValue(DataPermsCloumnEnum.CREATE_BY_ID, userRolePerms.getUserId());
        log.info("getDataPermsContext dataPermsContext: {}", (Object)JSON.toJSONString((Object)dataPermsContext));
        return dataPermsContext;
    }

    private boolean dataPermsCloumnExist(DataPermsEnum e) {
        switch (e) {
            case ADMIN: {
                return false;
            }
            case PLAT: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.TENANT_ID);
            }
            case OWNR: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.CREATE_BY_ID);
            }
            case DEPT_ONLY: 
            case DEPT_SUBS: 
            case DEPT_ALL: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.DEPARTMENT_ID);
            }
            case CMPY_ONLY: 
            case CMPY_SUBS: 
            case CMPY_ALL: {
                return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.COMPANY_ID);
            }
        }
        return DataPermsCloumnEnum.cloumnExist(DataPermsCloumnEnum.TENANT_ID);
    }
}

