/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.config;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.DataPermissionInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.holder.DataPermsHolder;
import top.cenze.interceptor.mybatis.CenzeDataPermissionHandler;
import top.cenze.interceptor.mybatis.SensitiveInterceptor;
import top.cenze.interceptor.mybatis.SqlCaptureInterceptor;

public abstract class CenzeMybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(CenzeMybatisPlusConfig.class);

    public CenzeMybatisPlusConfig(String tenantIdColumnName) {
        DataPermsHolder.setYmlIgnoreTableNames(null);
        DataPermsHolder.setYmlIncludeTableNames(null);
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(null);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(null);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(null);
    }

    public CenzeMybatisPlusConfig(String tenantIdColumnName, String companyIdColumnName, String departmentIdColumnName, String createByIdColumnName) {
        DataPermsHolder.setYmlIgnoreTableNames(null);
        DataPermsHolder.setYmlIncludeTableNames(null);
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(companyIdColumnName);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(departmentIdColumnName);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(createByIdColumnName);
    }

    public CenzeMybatisPlusConfig(String tenantIdColumnName, String companyIdColumnName, String departmentIdColumnName, String createByIdColumnName, String ignoreTableNames, String includeTableNames) {
        List lstDataScopeIncludeTableName;
        List lstDataScopeIgnoreTableName;
        if (StrUtil.isNotEmpty((CharSequence)ignoreTableNames) && CollectionUtil.isNotEmpty((Collection)(lstDataScopeIgnoreTableName = StrUtil.split((CharSequence)ignoreTableNames, (CharSequence)",")))) {
            DataPermsHolder.setYmlIgnoreTableNames(lstDataScopeIgnoreTableName);
        }
        if (StrUtil.isNotEmpty((CharSequence)includeTableNames) && CollectionUtil.isNotEmpty((Collection)(lstDataScopeIncludeTableName = StrUtil.split((CharSequence)includeTableNames, (CharSequence)",")))) {
            DataPermsHolder.setYmlIncludeTableNames(lstDataScopeIncludeTableName);
        }
        DataPermsCloumnEnum.TENANT_ID.setCloumnName(tenantIdColumnName);
        DataPermsCloumnEnum.COMPANY_ID.setCloumnName(companyIdColumnName);
        DataPermsCloumnEnum.DEPARTMENT_ID.setCloumnName(departmentIdColumnName);
        DataPermsCloumnEnum.CREATE_BY_ID.setCloumnName(createByIdColumnName);
    }

    @Bean
    public Boolean setAutoFillValueInterceptor(SqlSessionFactory sqlSessionFactory) {
        Configuration configuration = sqlSessionFactory.getConfiguration();
        configuration.addInterceptor((Interceptor)new SensitiveInterceptor());
        return Boolean.TRUE;
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new SqlCaptureInterceptor());
        interceptor.addInnerInterceptor((InnerInterceptor)new DataPermissionInterceptor((DataPermissionHandler)new CenzeDataPermissionHandler()));
        interceptor.addInnerInterceptor((InnerInterceptor)this.paginationInnerInterceptor());
        return interceptor;
    }

    public PaginationInnerInterceptor paginationInnerInterceptor() {
        PaginationInnerInterceptor paginationInnerInterceptor = new PaginationInnerInterceptor();
        paginationInnerInterceptor.setMaxLimit(Long.valueOf(-1L));
        return paginationInnerInterceptor;
    }
}

