/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.holder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.enums.DataPermsCloumnEnum;
import top.cenze.interceptor.enums.DataPermsEnum;
import top.cenze.interceptor.pojo.DataPermsContext;
import top.cenze.interceptor.pojo.MainTable;

public class DataPermsHolder {
    private static final Logger log = LoggerFactory.getLogger(DataPermsHolder.class);
    private static final ThreadLocal<DataPermsContext> DATA_SCOPE_CONTEXT_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<MainTable> MAIN_TABLE_NAME_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<String> SELECT_SQL_THREAD_LOCAL = new ThreadLocal();
    private static final List<String> YML_IGNORE_TABLE_NAMES = new ArrayList<String>();
    private static final List<String> YML_INCLUDE_TABLE_NAMES = new ArrayList<String>();
    private static final ThreadLocal<List<String>> AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<List<String>> AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL = new ThreadLocal();

    public static void setDataScope(DataPermsContext context) {
        log.debug("setDataScope context: {}", (Object)JSON.toJSONString((Object)context));
        DATA_SCOPE_CONTEXT_THREAD_LOCAL.set(context);
    }

    public static DataPermsContext getDataScope() {
        DataPermsContext dataPermsContext = DATA_SCOPE_CONTEXT_THREAD_LOCAL.get();
        log.debug("getDataScope context: {}", (Object)JSON.toJSONString((Object)dataPermsContext));
        return dataPermsContext;
    }

    public static void setMainTable(MainTable mainTable) {
        log.debug("setMainTable: {}", (Object)JSON.toJSONString((Object)mainTable));
        MAIN_TABLE_NAME_THREAD_LOCAL.set(mainTable);
    }

    public static MainTable getMainTable() {
        MainTable mainTable = MAIN_TABLE_NAME_THREAD_LOCAL.get();
        log.debug("getMainTable: {}", (Object)JSON.toJSONString((Object)mainTable));
        MAIN_TABLE_NAME_THREAD_LOCAL.remove();
        return mainTable;
    }

    public static void setSql(String sql) {
        log.debug("setSql: {}", (Object)sql);
        SELECT_SQL_THREAD_LOCAL.set(sql);
    }

    public static String getSql() {
        String sql = SELECT_SQL_THREAD_LOCAL.get();
        log.debug("getSql: {}", (Object)sql);
        SELECT_SQL_THREAD_LOCAL.remove();
        return sql;
    }

    public static void setYmlIgnoreTableNames(List<String> tableNames) {
        log.debug("setIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_IGNORE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIgnoreTableNames() {
        return YML_IGNORE_TABLE_NAMES;
    }

    public static void setYmlIncludeTableNames(List<String> tableNames) {
        log.debug("setYmlIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        YML_INCLUDE_TABLE_NAMES.addAll(tableNames);
    }

    public static List<String> getYmlIncludeTableNames() {
        return YML_INCLUDE_TABLE_NAMES;
    }

    public static void setAopIgnoreTableNames(List<String> tableNames) {
        log.debug("setAopIgnoreTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIgnoreTableNames() {
        return AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void setAopIncludeTableNames(List<String> tableNames) {
        log.debug("setAopIncludeTableNames tableNames: {}", (Object)JSON.toJSONString(tableNames));
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.set(tableNames);
    }

    public static List<String> getAopIncludeTableNames() {
        return AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.get();
    }

    public static void clearDataScope() {
        MAIN_TABLE_NAME_THREAD_LOCAL.remove();
        SELECT_SQL_THREAD_LOCAL.remove();
        DATA_SCOPE_CONTEXT_THREAD_LOCAL.remove();
        AOP_IGNORE_TABLE_NAMES_THREAD_LOCAL.remove();
        AOP_INCLUDE_TABLE_NAMES_THREAD_LOCAL.remove();
    }

    private static String getColumnName(String mainTableName, String columnName) {
        StringBuilder sb = new StringBuilder();
        sb.append(mainTableName).append(".").append(columnName).append(" ");
        return sb.toString();
    }

    public static List<Expression> getSqlSegment() {
        DataPermsContext context = DataPermsHolder.getDataScope();
        if (ObjectUtil.isNull((Object)context)) {
            return null;
        }
        List<DataPermsEnum> lstPerms = context.getDataScope();
        if (CollectionUtil.isEmpty(lstPerms) || lstPerms.contains((Object)DataPermsEnum.ADMIN)) {
            return null;
        }
        MainTable mainTable = DataPermsHolder.getMainTable();
        log.debug("getSqlSegment mainTable: {}", (Object)JSON.toJSONString((Object)mainTable));
        if (ObjectUtil.isNull((Object)mainTable) || StrUtil.isEmpty((CharSequence)mainTable.getTableName())) {
            return null;
        }
        List<String> aopIgnoreTableNames = DataPermsHolder.getAopIgnoreTableNames();
        if (CollectionUtil.isNotEmpty(aopIgnoreTableNames) && aopIgnoreTableNames.contains(mainTable.getTableName())) {
            return null;
        }
        List<String> ymlIgnoreTableNames = DataPermsHolder.getYmlIgnoreTableNames();
        if (CollectionUtil.isNotEmpty(ymlIgnoreTableNames) && ymlIgnoreTableNames.contains(mainTable.getTableName())) {
            return null;
        }
        List<String> aopIncludeTableNames = DataPermsHolder.getAopIncludeTableNames();
        if (CollectionUtil.isNotEmpty(aopIncludeTableNames) && !aopIncludeTableNames.contains(mainTable.getTableName())) {
            return null;
        }
        List<String> ymlIncludeTableNames = DataPermsHolder.getYmlIncludeTableNames();
        if (CollectionUtil.isNotEmpty(ymlIncludeTableNames) && !ymlIncludeTableNames.contains(mainTable.getTableName())) {
            return null;
        }
        if (ObjectUtil.isNull((Object)context)) {
            return null;
        }
        if (CollectionUtil.isEmpty(context.getDataScope())) {
            return null;
        }
        if (context.getDataScope().contains((Object)DataPermsEnum.DEPT_ONLY)) {
            context.getDataScope().remove((Object)DataPermsEnum.DEPT_SUBS);
            context.getDataScope().remove((Object)DataPermsEnum.DEPT_ALL);
        }
        if (context.getDataScope().contains((Object)DataPermsEnum.CMPY_ONLY)) {
            context.getDataScope().remove((Object)DataPermsEnum.CMPY_SUBS);
            context.getDataScope().remove((Object)DataPermsEnum.CMPY_ALL);
        }
        log.debug("getSqlSegment datascope: {}", (Object)JSON.toJSONString(context.getDataScope()));
        ArrayList<Expression> lstExp = new ArrayList<Expression>();
        for (DataPermsEnum scope : lstPerms) {
            if (ObjectUtil.isNull((Object)((Object)scope))) continue;
            Object exp = null;
            switch (scope) {
                case ADMIN: {
                    break;
                }
                case PLAT: {
                    if (!ObjectUtil.isNotNull((Object)context.getCreateById())) break;
                    exp = DataPermsHolder.buildEquals(mainTable, DataPermsCloumnEnum.TENANT_ID.getCloumnName(), context.getTenantId());
                    break;
                }
                case OWNR: {
                    if (!ObjectUtil.isNotNull((Object)context.getCreateById())) break;
                    exp = DataPermsHolder.buildEquals(mainTable, DataPermsCloumnEnum.CREATE_BY_ID.getCloumnName(), context.getCreateById());
                    break;
                }
                case DEPT_ONLY: {
                    if (!ObjectUtil.isNotNull((Object)context.getDepartmentId())) break;
                    exp = DataPermsHolder.buildEquals(mainTable, DataPermsCloumnEnum.DEPARTMENT_ID.getCloumnName(), context.getDepartmentId());
                    break;
                }
                case DEPT_SUBS: {
                    if (!CollectionUtil.isNotEmpty(context.getSubDepartmentIds())) break;
                    exp = DataPermsHolder.buildIn(mainTable, DataPermsCloumnEnum.DEPARTMENT_ID.getCloumnName(), context.getSubDepartmentIds());
                    break;
                }
                case DEPT_ALL: {
                    if (!CollectionUtil.isNotEmpty(context.getAllDepartmentIds())) break;
                    exp = DataPermsHolder.buildIn(mainTable, DataPermsCloumnEnum.DEPARTMENT_ID.getCloumnName(), context.getAllDepartmentIds());
                    break;
                }
                case CMPY_ONLY: {
                    if (!ObjectUtil.isNotNull((Object)context.getCompanyId())) break;
                    exp = DataPermsHolder.buildEquals(mainTable, DataPermsCloumnEnum.COMPANY_ID.getCloumnName(), context.getCompanyId());
                    break;
                }
                case CMPY_SUBS: {
                    if (!CollectionUtil.isNotEmpty(context.getSubCompanyIds())) break;
                    exp = DataPermsHolder.buildIn(mainTable, DataPermsCloumnEnum.COMPANY_ID.getCloumnName(), context.getSubCompanyIds());
                    break;
                }
                case CMPY_ALL: {
                    if (!CollectionUtil.isNotEmpty(context.getAllCompanyIds())) break;
                    exp = DataPermsHolder.buildIn(mainTable, DataPermsCloumnEnum.COMPANY_ID.getCloumnName(), context.getAllCompanyIds());
                    break;
                }
            }
            log.debug("getSqlSegment exp: {}", (Object)exp.toString());
            if (!ObjectUtil.isNotNull((Object)exp)) continue;
            lstExp.add((Expression)exp);
        }
        log.debug("getSqlSegment lstExp: {}", (Object)JSON.toJSONString(lstExp));
        return lstExp;
    }

    private static Expression buildEquals(MainTable table, String column, Object value) {
        String prefix = table.getAliasName() != null ? table.getAliasName() : table.getTableName();
        try {
            return CCJSqlParserUtil.parseCondExpression((String)String.format("%s.%s = %s", prefix, column, value));
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }

    private static Expression buildIn(MainTable table, String column, List<?> values) {
        String inValues = values.stream().map(Object::toString).collect(Collectors.joining(","));
        String prefix = table.getAliasName() != null ? table.getAliasName() : table.getTableName();
        try {
            return CCJSqlParserUtil.parseCondExpression((String)String.format("%s.%s IN (%s)", prefix, column, inValues));
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }
}

