/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.mybatis;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.handler.DataPermissionHandler;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.enums.DataPermsEnum;
import top.cenze.interceptor.holder.DataPermsHolder;
import top.cenze.interceptor.pojo.DataPermsContext;
import top.cenze.interceptor.pojo.MainTable;

public class CenzeDataPermissionHandler
implements DataPermissionHandler {
    private static final Logger log = LoggerFactory.getLogger(CenzeDataPermissionHandler.class);

    public Expression getSqlSegment(Expression where, String mappedStatementId) {
        try {
            DataPermsContext context = DataPermsHolder.getDataScope();
            if (ObjectUtil.isNull((Object)context)) {
                Expression expression = where;
                return expression;
            }
            List<DataPermsEnum> lstPerms = context.getDataScope();
            if (CollectionUtil.isEmpty(lstPerms) || lstPerms.contains((Object)DataPermsEnum.ADMIN)) {
                Expression expression = where;
                return expression;
            }
            String originalSql = DataPermsHolder.getSql();
            if (StrUtil.isEmpty((CharSequence)originalSql)) {
                Expression expression = where;
                return expression;
            }
            Select select = (Select)CCJSqlParserUtil.parse((String)originalSql);
            MainTable mainTable = this.parseMainTable(select);
            if (mainTable == null) {
                Expression expression = where;
                return expression;
            }
            DataPermsHolder.setMainTable(mainTable);
            List<Expression> conditions = DataPermsHolder.getSqlSegment();
            log.debug("getSqlSegment conditions: {}", (Object)JSON.toJSONString(conditions));
            if (CollectionUtil.isEmpty(conditions)) {
                Expression expression = where;
                return expression;
            }
            Expression reduce = conditions.stream().reduce(where, this::andCombine);
            log.debug("getSqlSegment reduce: {}", (Object)reduce.toString());
            Expression expression = reduce;
            return expression;
        }
        catch (Exception e) {
            throw new RuntimeException("Data permission process failed", e);
        }
        finally {
            DataPermsHolder.clearDataScope();
        }
    }

    private MainTable parseMainTable(Select select) {
        SelectBody selectBody = select.getSelectBody();
        if (!(selectBody instanceof PlainSelect)) {
            return null;
        }
        FromItem fromItem = ((PlainSelect)selectBody).getFromItem();
        if (!(fromItem instanceof Table)) {
            return null;
        }
        Table table = (Table)fromItem;
        MainTable mainTable = new MainTable();
        mainTable.setTableName(table.getName().replaceAll("`", ""));
        mainTable.setAliasName(table.getAlias() != null ? table.getAlias().getName() : null);
        return mainTable;
    }

    private Expression andCombine(Expression exist, Expression newExpr) {
        if (exist == null) {
            return newExpr;
        }
        return new AndExpression(exist, (Expression)new Parenthesis(newExpr));
    }
}

