/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.aspect;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.interceptor.holder.SensitiveHolder;

public class SensitiveAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveAspect.class);

    @Pointcut(value="@annotation(top.cenze.interceptor.aop.Sensitive)")
    public void cutSensitive() {
        log.debug("sensitive ...");
    }

    @Before(value="cutSensitive()")
    public void beforeSensitive(JoinPoint point) {
        log.debug("beforeSensitive ...");
        SensitiveHolder.setSensitive(true);
    }

    @After(value="cutSensitive()")
    public void afterSensitive() {
        log.debug("afterSensitive ...");
        SensitiveHolder.clearSensitive();
    }
}

