/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.interceptor.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationFilter;

public class AspectUtil {
    private static final Logger log = LoggerFactory.getLogger(AspectUtil.class);

    public static Map<String, Object> getRequestAllParams(JoinPoint point) {
        Map<String, Object> params = AspectUtil.getRequestParams(point);
        log.debug("getRequestAllParams params: {}", (Object)JSON.toJSONString(params));
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(allParams)) {
            for (Map.Entry entry : allParams.entrySet()) {
                String name = (String)entry.getKey();
                log.debug("getRequestAllParams name: {}", (Object)name);
                Object obj = entry.getValue();
                log.debug("getRequestAllParams obj: {}", (Object)JSON.toJSONString(obj));
                if (AspectUtil.isJavaLang(obj)) {
                    params.put(name, obj);
                    continue;
                }
                Map<String, Object> paramsByObj = AspectUtil.getParamsByObj(obj);
                log.debug("getRequestAllParams paramsByObj: {}", (Object)JSON.toJSONString(paramsByObj));
                if (!CollectionUtil.isNotEmpty(paramsByObj)) continue;
                allParams.putAll(paramsByObj);
            }
        }
        return allParams;
    }

    public static Map<String, Object> getRequestParams(JoinPoint point) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)point.getSignature();
        log.debug("getRequestParams signature: {}", (Object)JSON.toJSONString((Object)signature));
        Object[] args = point.getArgs();
        args = AspectUtil.filterArgs(args);
        log.debug("getRequestParams args: {}", (Object)JSON.toJSONString((Object)args));
        String[] paramNames = signature.getParameterNames();
        log.debug("getRequestParams paramNames: {}", (Object)JSON.toJSONString((Object)paramNames));
        if (ObjectUtil.isNotEmpty((Object)args) && ObjectUtil.isNotEmpty((Object)paramNames)) {
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (!(obj instanceof HttpServletRequest)) continue;
                String name = paramNames[i];
                params.put(name, obj);
            }
        }
        return params;
    }

    public static Object getParamByName(JoinPoint point, String name) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        log.debug("getParamByName signature: {}", (Object)JSON.toJSONString((Object)signature));
        Object[] args = point.getArgs();
        args = AspectUtil.filterArgs(args);
        log.debug("getParamByName args: {}", (Object)JSON.toJSONString((Object)args));
        if (ObjectUtil.isNotEmpty((Object)args)) {
            for (Object obj : args) {
                JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)obj));
                log.debug("getParamByName jsonObject: {}", (Object)JSON.toJSONString((Object)jsonObject));
                if (!jsonObject.containsKey((Object)name)) continue;
                return jsonObject.get((Object)name);
            }
        }
        return null;
    }

    public static Map<String, Object> getResponseAllParams(JoinPoint point) {
        Map<String, Object> params = AspectUtil.getResponseParams(point);
        HashMap<String, Object> allParams = new HashMap<String, Object>();
        if (CollectionUtil.isNotEmpty(allParams)) {
            for (Map.Entry entry : allParams.entrySet()) {
                String name = (String)entry.getKey();
                Object obj = entry.getValue();
                if (AspectUtil.isJavaLang(obj)) {
                    params.put(name, obj);
                    continue;
                }
                Map<String, Object> paramsByObj = AspectUtil.getParamsByObj(obj);
                if (!CollectionUtil.isNotEmpty(paramsByObj)) continue;
                allParams.putAll(paramsByObj);
            }
        }
        return allParams;
    }

    public static Map<String, Object> getResponseParams(JoinPoint point) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Object[] args = point.getArgs();
        args = AspectUtil.filterArgs(args);
        String[] paramNames = signature.getParameterNames();
        if (ObjectUtil.isNotEmpty((Object)args) && ObjectUtil.isNotEmpty((Object)paramNames)) {
            for (int i = 0; i < args.length; ++i) {
                Object obj = args[i];
                if (!(obj instanceof HttpServletResponse)) continue;
                String name = paramNames[i];
                params.put(name, obj);
            }
        }
        return params;
    }

    public static Map<String, Object> getParamsByObj(Object obj) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Field[] fields = obj.getClass().getDeclaredFields();
        if (ObjectUtil.isNotEmpty((Object)fields)) {
            for (Field field : fields) {
                field.setAccessible(true);
                String key = field.getName();
                try {
                    Object val = field.get(obj);
                    if (!ObjectUtil.isNotEmpty((Object)val)) continue;
                    params.put(key, val);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return params;
    }

    public static void setParamByName(JoinPoint point, String name, Object val) {
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        CharSequence[] names = methodSignature.getParameterNames();
        log.debug("setParamByName names: {}", (Object)JSON.toJSONString((Object)names));
        Object[] args = point.getArgs();
        log.debug("setParamByName args: {}", (Object)JSON.toJSONString((Object)args));
        if (ObjectUtil.isNull((Object)names) || ObjectUtil.isNull((Object)args) || 0 == names.length || 0 == args.length) {
            return;
        }
        int idx = ArrayUtil.indexOfIgnoreCase((CharSequence[])names, (CharSequence)name);
        log.debug("setParamByName idx: {}", (Object)idx);
        if (idx >= 0) {
            if (AspectUtil.isJavaLang(args[idx])) {
                args[idx] = val;
            }
        } else {
            for (Object obj : args) {
                Method setPlatformIdMethod = obj.getClass().getMethod("setPlatformId", Long.class);
                log.debug("setParamByName args2: {}", (Object)JSON.toJSONString((Object)args));
                if (ObjectUtil.isNull((Object)setPlatformIdMethod)) continue;
                setPlatformIdMethod.invoke(obj, val);
                log.debug("setParamByName args3: {}", (Object)JSON.toJSONString((Object)args));
            }
        }
    }

    public static boolean isJavaLang(Object obj) {
        return AnnotationFilter.PLAIN.matches(obj.getClass());
    }

    private static Object[] filterArgs(Object[] args) {
        return Arrays.stream(args).filter(p -> !(p instanceof HttpServletResponse) && !(p instanceof HttpServletRequest)).toArray();
    }
}

