package top.cenze.rule.frame.entity;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RuleHeaderAttributes {
    /**
     * 指定当前规则是否启用（默认为true）
     * 如果设置的值为false则当前规则无论是否匹配成功都不会触发
     * enabled false //指定当前规则不可用，当前规则无论是否匹配成功都不会执行
     */
    private Boolean enabled;

    /**
     * 指定当前规则使用的语言类型，取值为java和mvel，默认值为java
     * dialect java
     */
    private String dialect;

    /**
     * 指定规则的执行优先级，数值越大越优先执行
     * 如果不设置，则执行顺序为由上到下
     * salience 9
     */
    private Integer salience;

    /**
     * 是否不允许多次循环执行（默认为false，为true则只允许被执行一次）
     * 控制当前的规则只会被执行一次，因为一个规则的重复执行不一定是本身触发的，也可能是其他规则触发的
     * 是no-loop的加强版
     * lock-on-active true
     */
    private Boolean lockOnActive;

    /**
     * 激活分组
     * 具有相同分组名称的规则只能有一个规则被触发
     * activation-group "mygroup"
     */
    private String activationGroup;

    /**
     * 议程分组
     * 属于另一种可控的规则执行方式
     * 用户可以通过设置agenda-group来控制规则的执行，只有获取焦点的组中的规则才会被触发
     * agenda-group "myagendagroup_1"
     */
    private String agendaGroup;

    /**
     * 自动获取焦点（默认为false）
     * 一般结合agenda-group属性使用，当一个议程分组未获取焦点时，可以设置auto-focus属性来控制
     * agenda-group "myagendagroup_2"
     * auto-focus true //自动获取焦点
     */
    private Boolean autoFocus;

    /**
     * 规则定时（单位：毫秒）
     * duration 3000   // 3秒后执行规则
     */
    private Integer duration;

    /**
     * 通过定时器的方式指定规则执行的时间
     * - 方式一：timer (int: ?)
     * timer (5s 2s) //含义：5秒后触发，然后每隔2秒触发一次
     * 此种方式遵循java.util.Timer对象的使用方式，第一个参数表示几秒后执行，第二个参数表示每隔几秒执行一次，第二个参数为可选。
     * - 方式二：timer(cron: )
     * timer (cron:0/1 * * * * ?) //含义：每隔1秒触发一次
     * 此种方式使用标准的unix cron表达式的使用方式来定义规则执行的时间。
     */
    private String timer;

    /**
     * 指定规则的生效时间
     * 即只有当前系统时间大于等于设置的时间或者日期规则才有可能触发。默认日期格式为：dd-MMM-yyyy
     * 用户也可以自定义日期格式
     * date-effective "2020-10-01 10:00"
     */
    private String dateEffective;

    /**
     * 指定规则的失效时间
     * 即只有当前系统时间小于设置的时间或者日期规则才有可能触发。默认日期格式为：dd-MMM-yyyy
     * 用户也可以自定义日期格式
     * date-expires "2019-10-01 10:00"
     */
    private String dateExpires;
}
