package top.cenze.rule.frame.enums;

/**
 * 规则比较操作符
 */
public enum RuleAttributesEnum {
    ENABLED("enabled", "指定当前规则是否启用（默认为true）"),
    DIALECT("dialect", "指定当前规则使用的语言类型（取值为java和mvel，默认值为java）"),
    SALIENCE("salience", "指定规则的执行优先级（数值越大越优先执行）"),
    LOCK_ON_ACTIVE("lockOnActive", "是否不允许多次循环执行（默认为false，为true则只允许被执行一次）"),
    ACTIVATION_GROUP("activationGroup", "激活分组"),
    AGENDA_GROUP("agendaGroup", "议程分组"),
    AUTO_FOCUS("autoFocus", "自动获取焦点（默认为false）"),
    DURATION("duration", "规则定时（单位：毫秒）"),
    TIMER("timer", "通过定时器的方式指定规则执行的时间"),
    DATE_EFFECTIVE("dateEffective", "指定规则的生效时间"),
    DATE_EXPIRES("dateExpires", "指定规则的失效时间"),
    ;
    private String val;
    private String desc;

    RuleAttributesEnum(String _val, String _desc) {
        this.val = _val;
        this.desc = _desc;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
