package top.cenze.rule.frame.enums;

/**
 * 规则符号
 */
public enum RuleSymbolEnum {
    LPAREN("(", "左括号"),
    RPAREN(")", "右括号"),
    LBRACE("{", "左大括号"),
    RBRACE("}", "右大括号"),
    LBRACKET("[", "左中括号"),
    RBRACKET("]", "右中括号"),
    COLON(":", "冒号"),
    SEMI(";", "分号"),
    DQUOTE("\"", "双引号"),
    SQUOTE("\'", "单引号"),
    DOLLAR("$", "货币符号（变量标识符）"),
    SPACE(" ", "空格"),
    NEWLINE("\r\n", "换行"),
    ;
    private String val;
    private String desc;

    RuleSymbolEnum(String _val, String _desc) {
        this.val = _val;
        this.desc = _desc;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
