package top.cenze.rule.utils;

/**
 * @desc: 规则文件工具
 * @author: chengze
 * @createByDate: 2023/8/7 15:17
 */
public class RuleFileUtil {
//    private static final String DIR_NAME = "rules";             // 规则文件目录
//    private static final String RELATIVE_PATH = "src/main/resources/rules";  // 规则文件相对目录
//    private static final String EXT_NAME = ".drl";              // 规则文件扩展名
//    private static final String PACKAGE_PREFIX = "package ";    // 规则包名前缀
//    private static final String IMPORT_PREFIX = "import ";      // 规则引入前缀
//    private static final String RULE_NAME_PREFIX = "rule ";      // 规则名称前缀
//    private static final String RULE_WHEN = "when";      // 规则WHEN标识
//    private static final String RULE_THEN = "then";      // 规则THEN标识
//    private static final String RULE_END = "end";      // 规则END标识
//
//    private static final String EVAL_TRUE = "eval(true)";   // 默认条件
//
    // 文件内容写入器
//    private static FileWriter fw;
//
//    // 文件内容叠加器
//    private static StringBuilder sb;

    /**
     * 获取规则文件全路径
     * @param ruleFileName
     * @return
     */
//    public static String getRuleFileFullPath(String ruleFileName) {
//        String dir = getRuleFileDir();
//
////        return dir + File.separator + ruleFileName + EXT_NAME;
//        String filePath = dir + "\\" + ruleFileName + EXT_NAME;
//
//        return filePath;
//    }
//
//    /**
//     * 获取规则文件存储目录
//     * @return
//     */
//    public static String getRuleFileDir() {
//        // 获取项目资源文件根目录
//        String dir = ResourceUtil.getResource("").getPath();
//        // 去除每一个“/”字符（win系统）
//        dir = StrUtil.sub(dir, 1, dir.length());
//        // 获取最后一个字符
//        String lastChar = StrUtil.sub(dir, dir.length() - 1, dir.length());
//        // 拼接规则文件目录
//        if (File.separator.equals(lastChar)) {
//            dir = dir + DIR_NAME;
//        } else if ("/".equals(lastChar)) {
//            dir = dir + DIR_NAME;
//        } else {
//            dir = dir + File.separator + DIR_NAME;
//        }
//
//        return "D:\\Projects\\cenze\\cenze-rule-engine\\src\\test\\resources\\rules";
//    }
//
//    @SneakyThrows
//    public static void writeRuleFile(String ruleFileFullPath, String ruleFileContent) {
//        FileUtil.del(ruleFileFullPath);
//        File file = FileUtil.touch(ruleFileFullPath);
//
//        // 新增文件写入器
//        FileWriter fw = new FileWriter(file);
//        fw.write(ruleFileContent);
//        fw.close();
//    }

//    /**
//     * 重载规则
//     * @param rule
//     */
//    public static void reloadRuleContent(RuleDTO rule) {
//        if (ObjectUtil.isNull(rule) || StrUtil.isEmpty(rule.getRuleName()) || StrUtil.isEmpty(rule.getRuleContent())) {
//            new NullPointerException("规则对象、名称、内容不能为空");
//        }
//
//        List<RuleDTO> lstRule = new ArrayList<>();
//        lstRule.add(rule);
//
//        KieUtil.reloadRule(lstRule);
//    }
//
//    /**
//     * 重载规则文件
//     * @param ruleFileFullPath
//     * @return
//     * @throws UnsupportedEncodingException
//     */
//    public static void reloadRuleFile(String ruleFileFullPath) {
//        File file = new File(ruleFileFullPath);
//
//        reloadRuleFile(file);
//    }
//
//    /**
//     * 重载规则文件
//     * @param file
//     * @return
//     */
//    @SneakyThrows
//    public static void reloadRuleFile(File file) {
//        byte[] bytes = FileUtil.readBytes(file);
//        String ruleContent = new String(bytes, "UTF-8");
//
//        RuleDTO rule = new RuleDTO();
//        rule.setRuleName(file.getName());
//        rule.setRuleContent(ruleContent);
//
//        System.out.println("rule: " + JSON.toJSONString(rule));
//
//        List<RuleDTO> lstRule = new ArrayList<>();
//        lstRule.add(rule);
//
//        KieUtil.reloadRule(lstRule);
//    }

//    /**
//     * 初始化规则文件对象（创建一个测试规则文件对象）
//     * @return
//     */
//    public static RuleFile initRuleFile() {
//        RuleFile ruleFile = new RuleFile();
//        ruleFile.setFileName("rule");
//        ruleFile.setPackageName("top.cenze.rule");
//
//        List<String> imports = new ArrayList<>();
//        imports.add("top.cenze.rule.pojo.UserInfo");
//        imports.add("top.cenze.rule.utils.TestUtil");
//        ruleFile.setImports(imports);
//
//        List<String> lstRuleName = new ArrayList<>();
//
//        RuleHeader header = new RuleHeader();
//        header.setRuleName("test_rule");
//        header.setAttributes(null);
//        lstRuleName.add(header.getRuleName());
//
//        RuleBodyWhenLhs lhs = new RuleBodyWhenLhs();
//        lhs.setLhsObjBindName("userInfo");
//        lhs.setLhsObjName("UserInfo");
//        List<RuleBodyWhenSubLhs> lstSubLhs = new ArrayList<>();
//        RuleBodyWhenSubLhs subLhs = new RuleBodyWhenSubLhs();
//        subLhs.setLVal("age");
//        subLhs.setCmpOps(RuleCompOperatorEnum.LT.getVal());
//        subLhs.setRVal(50);
//        lstSubLhs.add(subLhs);
//        lhs.setLstSubLhs(lstSubLhs);
//        List<RuleBodyWhenLhs> lstLhs = new ArrayList<>();
//        lstLhs.add(lhs);
//
//        RuleBodyWhen rWhen = new RuleBodyWhen();
//        rWhen.setLhs(lstLhs);
//
//        RuleBodyThenRhs rhs = new RuleBodyThenRhs();
//        rhs.setRhs("$userInfo.setUserName(\"chengze\")");
//        List<RuleBodyThenRhs> lstRhs = new ArrayList<>();
//        lstRhs.add(rhs);
//
//        RuleBodyThen rThen = new RuleBodyThen();
//        rThen.setRhs(lstRhs);
//
//        RuleBody body = new RuleBody();
//        body.setRWhen(rWhen);
//        body.setRThen(rThen);
//
//        Rule rule = new Rule();
//        rule.setHeader(header);
//        rule.setBody(body);
//        List<Rule> lstRule = new ArrayList<>();
//        lstRule.add(rule);
//
//        ruleFile.setRules(lstRule);
//        ruleFile.setRuleNames(lstRuleName);
//
//        return ruleFile;
//    }
//
//    /**
//     * 创建规则文件
//     * @param ruleFile
//     */
//    @SneakyThrows
//    public static void createRuleFile(RuleFile ruleFile) {
//        // 获取规则文件全路径
//        String ruleFileFullPath = getRuleFileFullPath(ruleFile.getFileName());
//
//        // 规则引入
//        List<String> imports = ruleFile.getImports();
//        // 规则名称集合
//        List<String> ruleNames = ruleFile.getRuleNames();
//        // 规则集合
//        List<Rule> rules = ruleFile.getRules();
//
//        // =======================> 创建规则文件
//        FileUtil.touch(ruleFileFullPath);
//    }
//
//    /**
//     * 写入规则文件
//     * @param ruleFile  规则文件对象
//     * @param fwMode    写入方式（0叠加，1直接写入，默认为0）
//     */
//    @SneakyThrows
//    private static void fwRuleFile(RuleFile ruleFile, Integer fwMode) {
//        if (ObjectUtil.isNull(fwMode)) {
//            fwMode = 0;
//        }
//
//        // 获取规则文件全路径
//        String ruleFileFullPath = getRuleFileFullPath(ruleFile.getFileName());
//
//        // 规则引入
//        List<String> imports = ruleFile.getImports();
//        // 规则名称集合
//        List<String> ruleNames = ruleFile.getRuleNames();
//        // 规则集合
//        List<Rule> rules = ruleFile.getRules();
//
//        // =======================> 创建规则文件
//        File file = FileUtil.touch(ruleFileFullPath);
//
//        // 新增文件写入器
//        fw = new FileWriter(file);
//
//        // 写入规则package
//        if (fwMode != 0) {
//            fwNewLine(PACKAGE_PREFIX + ruleFile.getPackageName());
//        } else {
//            appendNewLine(PACKAGE_PREFIX + ruleFile.getPackageName());
//        }
//
//        // 写入规则imports
//        if (CollectionUtil.isNotEmpty(imports)) {
//            for (String imp : imports) {
//                if (StrUtil.isEmpty(imp)) {
//                    continue;
//                }
//
//                if (fwMode != 0) {
//                    fwNewLine(IMPORT_PREFIX + imp);
//                } else {
//                    appendNewLine(IMPORT_PREFIX + imp);
//                }
//            }
//        }
//
//        // -------------------------> 循环写入规则
//        for (Rule rule: rules) {
//            RuleHeader header = rule.getHeader();
//            RuleBody body = rule.getBody();
//            RuleBodyWhen rWhen = body.getRWhen();
//            List<RuleBodyWhenLhs> lstLhs = rWhen.getLhs();
//            RuleBodyThen rThen = body.getRThen();
//            List<RuleBodyThenRhs> lstRhs = rThen.getRhs();
//
//            // 写入规则名称
//            if (fwMode != 0) {
//                fwNewLine(RULE_NAME_PREFIX + RuleSymbolEnum.DQUOTE.getVal() + header.getRuleName() + RuleSymbolEnum.DQUOTE.getVal());
//            } else {
//                appendNewLine(RULE_NAME_PREFIX + RuleSymbolEnum.DQUOTE.getVal() + header.getRuleName() + RuleSymbolEnum.DQUOTE.getVal());
//            }
//
//            // 写入规则属性
//            fwRuleAttrs(header.getAttributes(), fwMode);
//
//            // 写入WHEN
//            fwRuleWhen(body.getRWhen(), fwMode);
//
//            // 写入THEN
//            fwRuleThen(body.getRThen(), fwMode);
//
//            // 规则END标识
//            if (fwMode != 0) {
//                fwNewLine(RULE_END);
//            } else {
//                appendNewLine(RULE_END);
//            }
//        }
//
//        if (0 == fwMode) {
//            fw.write(sb.toString());
//        }
//
//        fw.close();
//    }
//
//    /**
//     * 删除规则文件
//     * @param ruleFileName
//     */
//    public static void delRuleFile(String ruleFileName) {
//        String ruleFileFullPath = getRuleFileFullPath(ruleFileName);
//
//        FileUtil.del(ruleFileFullPath);
//    }
//
//    /**
//     * 清除规则文件
//     * @param ruleFileName
//     */
//    public static void cleanRuleFile(String ruleFileName) {
//        String ruleFileFullPath = getRuleFileFullPath(ruleFileName);
//
//        FileUtil.clean(ruleFileFullPath);
//    }
//
//    /**
//     * 写入规则属性
//     * @param attr
//     */
//    @SneakyThrows
//    private static void fwRuleAttrs(RuleHeaderAttributes attr, Integer fwMode) {
//        if (ObjectUtil.isNull(attr)) {
//            return;
//        }
//
//        // 写入当前规则是否启用属性
//        if (ObjectUtil.isNotNull(attr.getEnabled())) {
//            fwNewLine(RuleAttributesEnum.ENABLED.getVal() + " " + attr.getEnabled());
//        }
//
//        // 写入规则使用的语言类型（取值为java和mvel，默认值为java）属性
//        if (StrUtil.isNotEmpty(attr.getDialect())) {
//            fwNewLine(RuleAttributesEnum.DIALECT.getVal() + " " + attr.getDialect());
//        }
//
//        // 写入规则的执行优先级（数值越大越优先执行）属性
//        if (ObjectUtil.isNotNull(attr.getSalience())) {
//            fwNewLine(RuleAttributesEnum.SALIENCE.getVal() + " " + attr.getSalience());
//        }
//
//        // 写入是否不允许多次循环执行（默认为false，为true则只允许被执行一次）属性
//        if (ObjectUtil.isNotNull(attr.getLockOnActive())) {
//            fwNewLine(RuleAttributesEnum.LOCK_ON_ACTIVE.getVal() + " " + attr.getLockOnActive());
//        }
//
//        // 写入激活分组属性
//        if (StrUtil.isNotEmpty(attr.getActivationGroup())) {
//            fwNewLine(RuleAttributesEnum.ACTIVATION_GROUP.getVal() + " " + attr.getActivationGroup());
//        }
//
//        // 写入议程分组属性
//        if (StrUtil.isNotEmpty(attr.getAgendaGroup())) {
//            fwNewLine(RuleAttributesEnum.AGENDA_GROUP.getVal() + " " + attr.getAgendaGroup());
//        }
//
//        // 写入自动获取焦点（默认为false）属性
//        if (ObjectUtil.isNotNull(attr.getAutoFocus())) {
//            fwNewLine(RuleAttributesEnum.AUTO_FOCUS.getVal() + " " + attr.getAutoFocus());
//        }
//
//        // 写入规则定时（单位：毫秒）属性
//        if (ObjectUtil.isNotNull(attr.getDuration())) {
//            fwNewLine(RuleAttributesEnum.DURATION.getVal() + " " + attr.getDuration());
//        }
//
//        // 写入定时器的方式指定规则执行的时间属性
//        if (StrUtil.isNotEmpty(attr.getTimer())) {
//            fwNewLine(RuleAttributesEnum.TIMER.getVal() + " " + attr.getTimer());
//        }
//
//        // 写入规则的生效时间属性
//        if (StrUtil.isNotEmpty(attr.getDateEffective())) {
//            fwNewLine(RuleAttributesEnum.DATE_EFFECTIVE.getVal() + " " + attr.getDateEffective());
//        }
//
//        // 写入规则的失效时间属性
//        if (StrUtil.isNotEmpty(attr.getDateExpires())) {
//            fwNewLine(RuleAttributesEnum.DATE_EXPIRES.getVal() + " " + attr.getDateExpires());
//        }
//    }
//
//    /**
//     * 写入规则条件
//     * @param rWhen
//     */
//    @SneakyThrows
//    private static void fwRuleWhen(RuleBodyWhen rWhen, Integer fwMode) {
//        // 写入WHEN标识
//        fwNewLine(RULE_WHEN);
//
//        // 如果条件集合为空，则写入默认条件
//        if (CollectionUtil.isEmpty(rWhen.getLhs())) {
//            fwNewLine(EVAL_TRUE);
//
//            return;
//        }
//
//        // 循环写入规则条件
//        for (RuleBodyWhenLhs lhs: rWhen.getLhs()) {
//            if (ObjectUtil.isNull(lhs)) {
//                continue;
//            }
//
//            // 写入条件对象绑定变量名
//            if (StrUtil.isNotEmpty(lhs.getLhsObjBindName())) {
//                fw.write(RuleSymbolEnum.DOLLAR.getVal() + lhs.getLhsObjBindName() + RuleSymbolEnum.COLON.getVal());
//            }
//
//            // 写入条件对象
//            if (StrUtil.isNotEmpty(lhs.getLhsObjName())) {
//                fw.write(lhs.getLhsObjName());
//            }
//
//            // 写入对象左括号
//            fw.write(RuleSymbolEnum.LPAREN.getVal());
//
//            // 如果自定义条件不为空，写入自定义条件
//            if (StrUtil.isNotEmpty(lhs.getLhs())) {
//                fw.write(lhs.getLhs());
//            }
//            // 否则，写入拼接条件
//            else if (CollectionUtil.isNotEmpty(lhs.getLstSubLhs())) {
//                for (RuleBodyWhenSubLhs subLhs : lhs.getLstSubLhs()) {
//                    if (ObjectUtil.isNull(subLhs)) {
//                        continue;
//                    }
//
//                    // 写入左符号
//                    if (StrUtil.isNotEmpty(subLhs.getOpenSymbol())) {
//                        fw.write(subLhs.getOpenSymbol());
//                    }
//
//                    fw.write(subLhs.getLVal() + RuleSymbolEnum.SPACE.getVal());
//                    fw.write(subLhs.getCmpOps() + RuleSymbolEnum.SPACE.getVal());
//                    if (subLhs.getRVal() instanceof String) {
//                        fw.write(RuleSymbolEnum.DQUOTE.getVal() + (String)subLhs.getRVal() + RuleSymbolEnum.DQUOTE.getVal());
//                    } else {
//                        fw.write(Convert.toStr(subLhs.getRVal()));
//                    }
//
//                    // 写入右符号
//                    if (StrUtil.isNotEmpty(subLhs.getCloseSymbol())) {
//                        fw.write(subLhs.getCloseSymbol());
//                    }
//
//                    // 写入逻辑运算符
//                    if (StrUtil.isNotEmpty(subLhs.getLogicalOperator())) {
//                        fw.write(RuleSymbolEnum.SPACE.getVal() + subLhs.getLogicalOperator() + RuleSymbolEnum.SPACE.getVal());
//                    }
//                }
//            }
//
//            // 写入对象右括号
//            fw.write(RuleSymbolEnum.RPAREN.getVal());
//
//            // 写入换行
//            fwNewLine(RuleSymbolEnum.NEWLINE.getVal());
//        }
//    }
//
//    /**
//     * 写入THEN
//     * @param rThen
//     */
//    @SneakyThrows
//    private static void fwRuleThen(RuleBodyThen rThen, Integer fwMode) {
//        // 写入THEN标识
//        fwNewLine(RULE_THEN);
//
//        // 如果事务集合为空，则返回
//        if (CollectionUtil.isEmpty(rThen.getRhs())) {
//            return;
//        }
//
//        // 循环写入规则事务
//        for (RuleBodyThenRhs rhs : rThen.getRhs()) {
//            if (ObjectUtil.isNull(rhs)) {
//                continue;
//            }
//
//            // 写入事务
//            if (StrUtil.isNotEmpty(rhs.getRhs())) {
//                fwNewLine(rhs.getRhs());
//            }
//        }
//    }
//
//    /**
//     * 写入新的一行
//     * @param contant
//     * @throws IOException
//     */
//    private static void fwNewLine(String contant) throws IOException {
//        fw.write(contant + RuleSymbolEnum.NEWLINE.getVal());
//    }
//
//    // 追加新的一行
//    private static void appendNewLine(String contant) {
//        sb.append(contant + RuleSymbolEnum.NEWLINE.getVal());
//    }
}
