/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.rule.utils;

import cn.hutool.core.collection.CollectionUtil;
import java.util.List;
import java.util.Map;
import org.drools.core.base.RuleNameStartsWithAgendaFilter;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.AgendaFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.cenze.rule.dto.RuleBaseData;

public class KieUtil {
    private static final Logger log = LoggerFactory.getLogger(KieUtil.class);
    private static final String KIE_PACKAGE_PATH = "src/main/resources/rules/";
    private static final KieServices kieServices = KieServices.Factory.get();
    private static final KieFileSystem kieFileSystem = kieServices.newKieFileSystem();
    private static KieContainer kieContainer;
    private static KieBase kieBase;

    public static KieFileSystem getKieFileSystem() {
        return kieFileSystem;
    }

    public static KieContainer getKieContainer() {
        return kieContainer;
    }

    public static void setKieContainer(KieContainer kieContainer) {
        KieUtil.kieContainer = kieContainer;
    }

    public static KieServices getKieServices() {
        return kieServices;
    }

    public static KieBase getKieBase() {
        return kieBase;
    }

    public static void setKieBase(KieBase kieBase) {
        KieUtil.kieBase = kieBase;
    }

    public static void reloadRules(List<RuleBaseData> lstRule) {
        if (CollectionUtil.isEmpty(lstRule)) {
            return;
        }
        for (RuleBaseData rule : lstRule) {
            log.info("rule name: {}", (Object)rule.getRuleName());
            String drlFile = KIE_PACKAGE_PATH + rule.getRuleName() + ".drl";
            kieFileSystem.delete(new String[]{drlFile});
            kieFileSystem.write(drlFile, rule.getRuleContent());
        }
        KieBuilder kieBuilder = kieServices.newKieBuilder(kieFileSystem);
        kieBuilder.buildAll();
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new IllegalStateException("### load rules error ###");
        }
        kieContainer = kieServices.newKieContainer(kieServices.getRepository().getDefaultReleaseId());
        kieBase = kieContainer.getKieBase();
    }

    public static void execAll(Object obj) {
        KieSession kieSession = KieUtil.getKieBase().newKieSession();
        kieSession.insert(obj);
        kieSession.fireAllRules();
        kieSession.dispose();
    }

    public static void execAll(Object obj, Map<String, Object> mapGlobal) {
        KieSession kieSession = KieUtil.getKieBase().newKieSession();
        kieSession.insert(obj);
        if (CollectionUtil.isNotEmpty(mapGlobal)) {
            for (Map.Entry<String, Object> entry : mapGlobal.entrySet()) {
                kieSession.setGlobal(entry.getKey(), entry.getValue());
            }
        }
        kieSession.fireAllRules();
        kieSession.dispose();
    }

    public static void execByRuleName(Object obj, String ruleName) {
        KieSession kieSession = KieUtil.getKieBase().newKieSession();
        kieSession.insert(obj);
        kieSession.fireAllRules((AgendaFilter)new RuleNameStartsWithAgendaFilter(ruleName));
        kieSession.dispose();
    }

    public static void execByRuleName(Object obj, String ruleName, Map<String, Object> mapGlobal) {
        KieSession kieSession = KieUtil.getKieBase().newKieSession();
        kieSession.insert(obj);
        if (CollectionUtil.isNotEmpty(mapGlobal)) {
            for (Map.Entry<String, Object> entry : mapGlobal.entrySet()) {
                kieSession.setGlobal(entry.getKey(), entry.getValue());
            }
        }
        kieSession.fireAllRules((AgendaFilter)new RuleNameStartsWithAgendaFilter(ruleName));
        kieSession.dispose();
    }
}

