package top.cenze.rulepolicy.entity.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;
import top.cenze.rulepolicy.enums.FeeRuleEnum;
import top.cenze.rulepolicy.enums.TaxWayEnum;

import java.math.BigDecimal;

/**
 * @desc: 费用计算结果
 * @author: chengze
 * @createByDate: 2023/8/9 16:11
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class FeeDTO {
    /**
     * 计算规则
     */
    private FeeRuleEnum feeRule;

    /**
     * 计算所得费用保留小数点位数
     */
    private Integer scale;

    /**
     * 重量
     */
    private BigDecimal weight;

    /**
     * 重量小数点位数
     */
    private Integer weightScale;

    /**
     * 数量
     */
    private BigDecimal quantity;

    /**
     * 数量小数点位数
     */
    private Integer quantityScale;

    /**
     * 体积
     */
    private BigDecimal volume;

    /**
     * 体积小数点位数
     */
    private Integer volumeScale;

    /**
     * 单价
     */
    private BigDecimal price;

    /**
     * 单价小数点位数
     */
    private Integer priceScale;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 税率小数点位数
     */
    private Integer taxScale;

    /**
     * 计税方式
     */
    private TaxWayEnum taxWay;

    /**
     * 不含税金额
     */
    private BigDecimal originalAmount;

    /**
     * 含税金额
     */
    private BigDecimal actualAmount;

    /**
     * 税额
     */
    private BigDecimal taxAmount;
}
