package top.cenze.rulepolicy.frame.enums;

/**
 * 规则比较操作符（关系运算符）
 */
public enum RuleCompOperatorEnum {
    GT(">", "大于"),
    LT("<", "小于"),
    GE(">=", "大于等于"),
    LE("<=", "小于等于"),
    EQ("==", "等于"),
    NE("!=", "不等于"),
    CON("contains", "检查一个Fact对象的某个属性值是否包含一个指定的对象值"),
    NCON("not contains", "检查一个Fact对象的某个属性值是否不包含一个指定的对象值"),
    MO("memberOf", "判断一个Fact对象的某个属性是否在一个或多个集合中"),
    NMO("not memberOf", "判断一个Fact对象的某个属性是否不在一个或多个集合中"),
    MCH("matches", "判断一个Fact对象的属性是否与提供的标准的Java正则表达式进行匹配"),
    NMCH("not matches", "判断一个Fact对象的属性是否不与提供的标准的Java正则表达式进行匹配"),
    IN("in", "in复合值匹配"),
    NIN("not in", "not in复合值匹配"),
    EVAL("eval", "类似于 while"),
    NOT("not", "判断Working Memory中是否存在某个Fact对象，如果不存在则返回true，如果存在则返回false"),
    EXISTS("exist", "判断Working Memory中是否存在某个Fact对象，如果存在则返回true，不存在则返回false"),
    EXTENDS("extends", "规则条件部分的继承"),
    ;
    private String val;
    private String desc;

    RuleCompOperatorEnum(String _val, String _desc) {
        this.val = _val;
        this.desc = _desc;
    }

    public String getVal() {
        return val;
    }

    public void setVal(String val) {
        this.val = val;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
