package top.cenze.rulepolicy.frame.rule;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.List;

/**
 * When条件
 * lhs自定义条件优先于通过左右值组成的条件
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RuleBodyWhenLhs {
    /**
     * 条件主体对象绑定变量名
     */
    private String lhsObjBindName;

    /**
     * 条件主体对象名
     */
    private String lhsObjName;

    /**
     * 自定义条件
     */
    private String lhs;

    /**
     * 对象匹配子条件
     */
    private List<RuleBodyWhenSubLhs> lstSubLhs;
}
