package top.cenze.rulepolicy.frame.rule;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

/**
 * When条件
 * lhs自定义条件优先于通过左右值组成的条件
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RuleBodyWhenSubLhs {

    /**
     * 左符号（取值RuleSymbolEnum，L开头符号）
     */
    private String openSymbol;
    /**
     * 自定义条件
     */
    private String lhs;

    /**
     * 左值
     */
    private String lVal;

    /**
     * 比较操作符（取值RuleCompOperatorEnum）
     */
    private String cmpOps;

    /**
     * 右值
     */
    private Object rVal;

    /**
     * 右符号（取值RuleSymbolEnum，R开头符号）
     */
    private String closeSymbol;

    /**
     * 逻辑运算符（取值RuleLogicalOperatorEnum）
     */
    private String logicalOperator;
}
