package top.cenze.rulepolicy.frame.rule;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.List;

/**
 * @desc: 规则文件
 * @author: chengze
 * @createByDate: 2023/8/7 13:33
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RuleFile {
    /**
     * 规则文件名
     */
    private String fileName;

    /**
     * 规则package名
     */
    private String packageName;

    /**
     * 规则引入包集合
     */
    private List<String> imports;

    /**
     * 规则集合
     */
    private List<Rule> rules;

    /**
     * 规则名集合
     */
    private List<String> ruleNames;
}
