package top.cenze.rulepolicy.frame.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.utils.KieHelper;
import top.cenze.rulepolicy.frame.entity.dto.RuleDTO;

import java.util.List;

/**
 * @desc: 规则管理工具
 * @author: chengze
 * @createByDate: 2023/8/8 17:30
 */
public class KieUtil {

    private static KieServices kieServices = KieServices.Factory.get();
    private static KieContainer kieContainer;
    private static KieBase kieBase;

    public static KieContainer getKieContainer() {
        return kieContainer;
    }

    public static void setKieContainer(KieContainer kieContainer) {
        KieUtil.kieContainer = kieContainer;
    }

    public static KieServices getKieServices() {
        return kieServices;
    }

    public static KieBase getKieBase() {
        return kieBase;
    }

    public static void setKieBase(KieBase kieBase) {
        KieUtil.kieBase = kieBase;
    }

    /**
     * 重载规则
     * @param lstRule
     */
    public static void reloadRule(List<RuleDTO> lstRule) {
        // 借助 kieHelper 添加规则
        KieHelper kieHelper = new KieHelper();
        // 从数据库中获取所有的规则
        if (CollectionUtil.isNotEmpty(lstRule)) {
            // 循环加载所有的规则
            for (RuleDTO rule : lstRule) {
                String content = rule.getRuleContent();
                kieHelper.addContent(content, ResourceType.DRL);
            }
        }
        // 校验规则是否异常
        Results results = kieHelper.verify();
        System.out.println("results: " + JSON.toJSONString(results));
        if (results.hasMessages(Message.Level.ERROR)) {
            System.out.println(results.getMessages());
            throw new IllegalStateException("### errors ###");
        }
        // 重置容器
        KieContainer kieContainer = kieHelper.getKieContainer();
        KieUtil.setKieContainer(kieContainer);

        // 重置规则库
        KieBase kieBase = kieContainer.getKieBase();
        KieUtil.setKieBase(kieBase);
    }
}
