/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.rulepolicy.frame.config;

import java.io.IOException;
import org.kie.api.KieBase;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.kie.internal.io.ResourceFactory;
import org.kie.spring.KModuleBeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.cenze.rulepolicy.frame.utils.KieUtil;

@Configuration
public class DroolsConfig {
    public static final String RULES_PATH = "rules/";

    @Bean
    @ConditionalOnMissingBean
    public KieFileSystem kieFileSystem() throws IOException {
        KieFileSystem kieFileSystem = KieUtil.getKieServices().newKieFileSystem();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] files = resourcePatternResolver.getResources("classpath*:rules/*.*");
        String path = null;
        for (Resource file : files) {
            path = RULES_PATH + file.getFilename();
            kieFileSystem.write(ResourceFactory.newClassPathResource((String)path, (String)"UTF-8"));
        }
        return kieFileSystem;
    }

    @Bean
    @ConditionalOnMissingBean
    public KieContainer kieContainer() throws IOException {
        KieRepository kieRepository = KieUtil.getKieServices().getRepository();
        kieRepository.addKieModule(() -> ((KieRepository)kieRepository).getDefaultReleaseId());
        KieBuilder kieBuilder = KieUtil.getKieServices().newKieBuilder(this.kieFileSystem());
        kieBuilder.buildAll();
        KieContainer kieContainer = KieUtil.getKieServices().newKieContainer(kieRepository.getDefaultReleaseId());
        KieUtil.setKieContainer(kieContainer);
        return kieContainer;
    }

    @Bean
    @ConditionalOnMissingBean
    public KieBase kieBase() throws IOException {
        KieBase kieBase = this.kieContainer().getKieBase();
        KieUtil.setKieBase(kieBase);
        return kieBase;
    }

    @Bean
    @ConditionalOnMissingBean
    public KieSession kieSession() throws IOException {
        KieSession kieSession = this.kieBase().newKieSession();
        return kieSession;
    }

    @Bean
    @ConditionalOnMissingBean
    public KModuleBeanFactoryPostProcessor kiePostProcessor() {
        return new KModuleBeanFactoryPostProcessor();
    }
}

