/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.rulepolicy.frame.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.KieContainer;
import org.kie.internal.utils.KieHelper;
import top.cenze.rulepolicy.frame.entity.dto.RuleDTO;

public class KieUtil {
    private static KieServices kieServices = KieServices.Factory.get();
    private static KieContainer kieContainer;
    private static KieBase kieBase;

    public static KieContainer getKieContainer() {
        return kieContainer;
    }

    public static void setKieContainer(KieContainer kieContainer) {
        KieUtil.kieContainer = kieContainer;
    }

    public static KieServices getKieServices() {
        return kieServices;
    }

    public static KieBase getKieBase() {
        return kieBase;
    }

    public static void setKieBase(KieBase kieBase) {
        KieUtil.kieBase = kieBase;
    }

    public static void reloadRule(List<RuleDTO> lstRule) {
        KieHelper kieHelper = new KieHelper();
        if (CollectionUtil.isNotEmpty(lstRule)) {
            for (RuleDTO rule : lstRule) {
                String content = rule.getRuleContent();
                kieHelper.addContent(content, ResourceType.DRL);
            }
        }
        Results results = kieHelper.verify();
        System.out.println("results: " + JSON.toJSONString((Object)results));
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            System.out.println(results.getMessages());
            throw new IllegalStateException("### errors ###");
        }
        KieContainer kieContainer = kieHelper.getKieContainer();
        KieUtil.setKieContainer(kieContainer);
        KieBase kieBase = kieContainer.getKieBase();
        KieUtil.setKieBase(kieBase);
    }
}

