/*
 * Decompiled with CFR 0.152.
 */
package top.cenze.rulepolicy.utils;

import cn.hutool.core.util.ObjectUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.kie.api.runtime.KieSession;
import org.springframework.stereotype.Component;
import top.cenze.rulepolicy.entity.dto.FeeDTO;
import top.cenze.rulepolicy.enums.TaxWayEnum;
import top.cenze.rulepolicy.frame.utils.KieUtil;

@Component
public class FeeRuleUtil {
    private static Integer PARAM_DEFAULT_SCALE = 6;
    private static Integer RESULT_DEFAULT_SCALE = 2;

    public static void calculate(FeeDTO dto) {
        FeeRuleUtil.formatParam(dto);
        FeeRuleUtil.ruleFee(dto);
    }

    public static void ruleFee(FeeDTO dto) {
        KieSession kieSession = KieUtil.getKieBase().newKieSession();
        kieSession.insert((Object)dto);
        kieSession.fireAllRules();
        kieSession.dispose();
    }

    private static void formatParam(FeeDTO dto) {
        switch (dto.getFeeRule()) {
            case VOLUME: {
                if (ObjectUtil.isNull((Object)dto.getVolume())) {
                    throw new NullPointerException("volume is null");
                }
                if (ObjectUtil.isNull((Object)dto.getVolumeScale())) {
                    dto.setVolumeScale(PARAM_DEFAULT_SCALE);
                }
                dto.setVolume(dto.getVolume().setScale((int)dto.getVolumeScale(), RoundingMode.HALF_UP));
                break;
            }
            case WEIGHT: {
                if (ObjectUtil.isNull((Object)dto.getWeight())) {
                    throw new NullPointerException("weigth is null");
                }
                if (ObjectUtil.isNull((Object)dto.getWeightScale())) {
                    dto.setWeightScale(PARAM_DEFAULT_SCALE);
                }
                dto.setWeight(dto.getWeight().setScale((int)dto.getWeightScale(), RoundingMode.HALF_UP));
                break;
            }
            case QUANTITY: {
                if (ObjectUtil.isNull((Object)dto.getQuantity())) {
                    throw new NullPointerException("quantity is null");
                }
                if (ObjectUtil.isNull((Object)dto.getQuantityScale())) {
                    dto.setQuantityScale(PARAM_DEFAULT_SCALE);
                }
                dto.setQuantity(dto.getQuantity().setScale((int)dto.getQuantityScale(), RoundingMode.HALF_UP));
            }
        }
        if (ObjectUtil.isNotNull((Object)((Object)dto.getTaxWay()))) {
            if (ObjectUtil.isNull((Object)dto.getTaxRate())) {
                throw new NullPointerException("taxRate is null");
            }
            if (ObjectUtil.isNull((Object)dto.getTaxScale())) {
                dto.setTaxScale(PARAM_DEFAULT_SCALE);
            }
            dto.setTaxRate(dto.getTaxRate().setScale((int)dto.getTaxScale(), RoundingMode.HALF_UP));
        } else {
            dto.setTaxWay(TaxWayEnum.MULTIPLY);
            dto.setTaxRate(BigDecimal.ZERO);
        }
        if (ObjectUtil.isNull((Object)dto.getPrice())) {
            throw new NullPointerException("price is null");
        }
        if (ObjectUtil.isNull((Object)dto.getScale())) {
            dto.setScale(RESULT_DEFAULT_SCALE);
        }
        if (ObjectUtil.isNull((Object)dto.getPriceScale())) {
            dto.setPriceScale(PARAM_DEFAULT_SCALE);
        }
        dto.setPrice(dto.getPrice().setScale((int)dto.getPriceScale(), RoundingMode.HALF_UP));
    }
}

