package top.cenze.utils;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @desc: 金额AES加密
 * @author: chengze
 * @createByDate: 2023/10/12 9:54
 */
@Slf4j
public class AmountAesUtil {
    private final static String KEY = "D7WsKIRHPNqXLE2z";

    public static Double decode(String source) {
        if(StringUtils.isBlank(source)) {
            return 0.0D;
        }
        try {
            final AES aes = SecureUtil.aes(KEY.getBytes());

            String s = aes.decryptStr(source);
            if (StringUtils.isBlank(s)) {
                return 0.0;
            }

            return Double.parseDouble(s);
        } catch (Exception e) {
            log.error("price decode error:", e);
            return 0.0;
        }
    }

    public static String encode(Double price) {
        final AES aes = SecureUtil.aes(KEY.getBytes());
        return aes.encryptHex(String.valueOf(price));
    }

    public static String encodeHex(Double price) {
        final AES aes = SecureUtil.aes(KEY.getBytes());
        return aes.encryptHex(String.valueOf(price));
    }

    public static Double decodeStr(String source) {
        final AES aes = SecureUtil.aes(KEY.getBytes());

        String s = aes.decryptStr(source);
        if (StringUtils.isBlank(s)) {
            return 0.0;
        }

        return Double.parseDouble(s);
    }

//    public static void main(String[] args) {
//        double price = 2.0D;
//        String hex = PriceUtil.encodeHex(price);
//        System.out.println(hex);
//        System.out.println(PriceUtil.decodeStr("a01c2e5ff36aa79e5e093a77c0e6baf6"));
//        System.out.println(PriceUtil.decodeStr("A01C2E5FF36AA79E5E093A77C0E6BAF6"));
//        System.out.println(PriceUtil.decode(null));
//    }
}
