package top.cenze.utils.pojo;

import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.Data;

import java.util.List;

/**
 * @desc: excel映射
 * @author: chengze
 * @createByDate: 2023/10/11 8:51
 */
@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExcelMapping {

//    @ApiModelProperty(value = "Excel表文件Sheet索引，从0开始计")
    private Integer sheetIndex;

//    @ApiModelProperty(value = "最大行索引值（有效起始值0）")
    private Integer maxRow;

//    @ApiModelProperty(value = "最大列索引值（有效起始值0）")
    private Integer maxCol;

//    @ApiModelProperty(value = "自定义映射集合（直接取值）")
    private List<ExcelMappingCustom> lstCustom;

//    @ApiModelProperty(value = "数据对象集合（直接对象取值）")
    private List<ExcelMappingObject> lstObject;

//    @ApiModelProperty(value = "Loop数据集合（遍历取值）")
    private ExcelMappingLoop mappingLoop;
}
