package top.cenze.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModelProperty;
import top.cenze.utils.pojo.ClassFieldInfo;
import top.cenze.utils.pojo.ClassFields;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

/**
 * @desc: 反射工具类
 * @author: chengze
 * @createByDate: 2023/10/30 9:32
 */
public class ReflectionUtil {

    public static <T> ClassFields getFields(Class<T> clazz) {
        ClassFields classFields = new ClassFields();

        // 获取接口类或父类继承的字段
        Field[] fields = clazz.getFields();
        if (ObjectUtil.isNotNull(fields)) {
            List<ClassFieldInfo> lstClassFieldInfo = getFieldsAndSwaggerModelPropertyValue(fields, true);
            if (CollectionUtil.isNotEmpty(lstClassFieldInfo)) {
                classFields.setLstParentField(lstClassFieldInfo);
            }
        }

        // 获取本类的字段
        Field[] declaredFields = clazz.getDeclaredFields();
        if (ObjectUtil.isNotNull(declaredFields)) {
            List<ClassFieldInfo> lstClassFieldInfo = getFieldsAndSwaggerModelPropertyValue(declaredFields, false);
            if (CollectionUtil.isNotEmpty(lstClassFieldInfo)) {
                classFields.setLstDeclaredField(lstClassFieldInfo);
            }
        }

        return classFields;
    }

    private static List<ClassFieldInfo> getFieldsAndSwaggerModelPropertyValue(Field[] fields, Boolean isParent) {
        if (ObjectUtil.isNull(isParent)) {
            isParent = false;
        }

        List<ClassFieldInfo> lstClassFieldInfo = new ArrayList<>();
        if (ObjectUtil.isNotNull(fields)) {
            for (Field field : fields) {
                field.setAccessible(true);

                ClassFieldInfo classFieldInfo = new ClassFieldInfo();
                classFieldInfo.setName(field.getName());
                classFieldInfo.setType(field.getType().getName());
                classFieldInfo.setDesc(getFieldSwaggerModelPropertyValue(field));
                classFieldInfo.setIsParent(isParent);

                lstClassFieldInfo.add(classFieldInfo);
            }
        }

        return lstClassFieldInfo;
    }

    /**
     * 获取字段Swagger属性描述
     * @param field
     * @param <T>
     * @return
     */
    private static <T> String getFieldSwaggerModelPropertyValue(Field field) {
        ApiModelProperty annotation = field.getDeclaredAnnotation(ApiModelProperty.class);
        if (ObjectUtil.isNotNull(annotation)) {
            return annotation.value();
        }

        return null;
    }
}
